/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.compiler.build.Logging;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.util.HashMap;

public class GroupIdService
implements Logging {
    private static HashMap<String, HashMap<String, String>> groupIdsMaps = new HashMap();
    private static final String ID_FILE = ".group";

    private GroupIdService() {
    }

    public static String getUniqueId(String groupId, File parentDir) {
        String uniqueId;
        HashMap<String, String> groupIds = GroupIdService.getGroupIds(parentDir);
        int index = groupId.lastIndexOf(47);
        if (index != -1) {
            groupId = groupId.substring(index + 1);
        }
        if ((uniqueId = groupIds.get(groupId)) == null) {
            uniqueId = UniqueIdService.createUniqueId((String)groupId, groupIds);
        }
        return uniqueId;
    }

    private static HashMap<String, String> getGroupIds(File parentDir) {
        HashMap groupIds = groupIdsMaps.get(FileUtilities.getAbsolutePath((File)parentDir));
        if (groupIds == null) {
            try {
                groupIds = UniqueIdService.loadUniqueIds((File)new File(parentDir, ID_FILE));
                groupIdsMaps.put(FileUtilities.getAbsolutePath((File)parentDir), groupIds);
            }
            catch (WrongIDFileVersionException e) {
                logger.finest("Caught a " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            }
        }
        return groupIds;
    }

    public static void removeIds(File parentDir) {
        HashMap<String, String> groupIds = groupIdsMaps.get(FileUtilities.getAbsolutePath((File)parentDir));
        if (groupIds != null) {
            groupIds.clear();
        }
    }

    public static void saveAndClear() {
        for (String key : groupIdsMaps.keySet()) {
            HashMap<String, String> map = groupIdsMaps.get(key);
            UniqueIdService.saveIds(map, (File)new File(key, ID_FILE));
            map.clear();
        }
        groupIdsMaps.clear();
    }
}

