/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.test;

import ch.e2e.builder.traceviewer.execute.test.TestcaseDifference;
import ch.e2e.dom.DomUtilities;
import ch.e2e.test.DocumentSerializer;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import ch.e2e.test.TestDocumentPreprocessor;
import ch.e2e.test.TestResult;
import ch.e2e.test.XMLCompare;
import ch.e2e.transformer.TransformerLoadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LogfileCompare {
    private File testFile;
    private File referenceFile;
    private boolean namespaceAware;
    private boolean validate;
    private boolean schemaValidation;
    private TestDocumentPreprocessor preprocessor;
    private Serializer serializer;

    public LogfileCompare(File testFile, File referenceFile, TestDocumentPreprocessor preprocessor) {
        this.testFile = testFile;
        this.referenceFile = referenceFile;
        this.preprocessor = preprocessor;
        this.validate = false;
        this.schemaValidation = false;
        this.namespaceAware = false;
        if (preprocessor != null) {
            this.serializer = new Serializer();
            preprocessor.setSerializer((DocumentSerializer)this.serializer);
        }
    }

    public void compare(TestcaseDifference difference, Collection<String> ignoreAttributes, Collection<String> ignoreElements) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException {
        StringBuffer testHeader = new StringBuffer();
        StringBuffer testDom = new StringBuffer();
        try {
            this.readFile(this.testFile, testHeader, testDom);
        }
        catch (IOException ex) {
            difference.addException(ex, this.testFile);
        }
        StringBuffer referenceHeader = new StringBuffer();
        StringBuffer referenceDom = new StringBuffer();
        try {
            this.readFile(this.referenceFile, referenceHeader, referenceDom);
        }
        catch (IOException ex) {
            difference.addException(ex, this.referenceFile);
        }
        this.compareHeader(testHeader.toString(), referenceHeader.toString(), difference);
        this.compareDom(testDom.toString(), referenceDom.toString(), difference, ignoreAttributes, ignoreElements, testHeader.toString(), referenceHeader.toString());
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void appendResultDocuments(TestResult testResult, boolean includeHiddenData, Collection<String> ignoredElements, Collection<String> ignoredAttributes) {
        StringBuffer testHeader = new StringBuffer();
        StringBuffer testDom = new StringBuffer();
        try {
            this.readFile(this.testFile, testHeader, testDom);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        StringBuffer referenceHeader = new StringBuffer();
        StringBuffer referenceDom = new StringBuffer();
        try {
            this.readFile(this.referenceFile, referenceHeader, referenceDom);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        StringWriter testWriter = new StringWriter();
        StringWriter referenceWriter = new StringWriter();
        try {
            Document testDocument = null;
            if (testDom.length() > 0) {
                testDocument = this.createDocument(testDom.toString());
            }
            Document referenceDocument = null;
            if (referenceDom.length() > 0) {
                referenceDocument = this.createDocument(referenceDom.toString());
            }
            if (!includeHiddenData) {
                XMLCompare.removeHiddenData((Document)referenceDocument, (Document)testDocument, ignoredElements, ignoredAttributes);
            }
            if (referenceDocument != null) {
                DomUtilities.serialize((Writer)referenceWriter, (Document)referenceDocument, (boolean)true);
            }
            if (testDocument != null) {
                DomUtilities.serialize((Writer)testWriter, (Document)testDocument, (boolean)true);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        String referenceData = referenceWriter.toString();
        int referenceLines = referenceData.split("\n").length;
        String testData = testWriter.toString();
        int testLines = testData.split("\n").length;
        int diff = referenceLines - testLines;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                testData = testData + "\n";
            }
        } else {
            diff = Math.abs(diff);
            for (int i = 0; i < diff; ++i) {
                referenceData = referenceData + "\n";
            }
        }
        testResult.setReferenceData(testResult.getReferenceData() + referenceData);
        testResult.setTestData(testResult.getTestData() + testData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file, StringBuffer header, StringBuffer dom) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            String line = in.readLine();
            while (line != null && !line.startsWith("<?xml")) {
                header.append(line).append('\n');
                line = in.readLine();
            }
            while (line != null) {
                dom.append(line).append('\n');
                line = in.readLine();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void compareHeader(String test, String reference, TestcaseDifference difference) {
    }

    private void compareDom(String test, String reference, TestcaseDifference difference, Collection<String> ignoreAttributes, Collection<String> ignoreElements, String testHeader, String referenceHeader) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException {
        Document testDocument = this.createDocument(test);
        Document referenceDocument = this.createDocument(reference);
        if (this.preprocessor != null) {
            this.serializer.header = testHeader;
            this.preprocessor.savePreprocessedDocument(testDocument, this.testFile.getName() + ".test");
            this.serializer.header = referenceHeader;
            this.preprocessor.savePreprocessedDocument(referenceDocument, this.referenceFile.getName() + ".reference");
        }
        E2EComparisonController controller = new E2EComparisonController();
        E2EDiff diff = new E2EDiff(referenceDocument, testDocument, (DifferenceEngine)new E2EDifferenceEngine((ComparisonController)controller, ignoreAttributes, ignoreElements), this.referenceFile.getAbsolutePath());
        difference.appendXMLDiff((Diff)diff);
    }

    private Document createDocument(String domText) throws IOException, SAXException, ParserConfigurationException, TransformerException, TransformerLoadException {
        Document document = this.preprocessor == null ? DomUtilities.parse((Reader)new StringReader(domText), (boolean)this.validate, (boolean)this.schemaValidation, (boolean)this.namespaceAware) : this.preprocessor.preprocess(DomUtilities.parse((Reader)new StringReader(domText), (boolean)this.validate, (boolean)this.schemaValidation, (boolean)this.namespaceAware));
        return document;
    }

    private class Serializer
    implements DocumentSerializer {
        private String header;

        private Serializer() {
        }

        public void serialize(Document document, File file, boolean indent) throws TransformerException, IOException {
            PrintWriter out = new PrintWriter(file);
            if (this.header != null) {
                out.println(this.header);
            }
            DomUtilities.serialize((Writer)out, (Document)document, (boolean)indent);
            out.flush();
            out.close();
        }
    }
}

