/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.trace.execute.HttpClient;
import ch.e2e.builder.trace.execute.RequestPool;
import ch.e2e.builder.trace.execute.SynchronousTestcaseRequest;
import ch.e2e.builder.trace.request.SOAPFault;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.traceviewer.execute.test.TestcaseCompare;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcase;
import ch.e2e.io.FileUtilities;
import ch.e2e.secure.HttpsUtil;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RunTestcaseTest
extends E2ETest {
    public static final String KEY = "TestcaseTest";
    public static final String KEY_OPTION_TESTCASE_HOME = "run.testcase.test.testcase.home";
    public static final String KEY_OPTION_OPERATION = "run.testcase.test.operation";
    public static final String KEY_OPTION_TESTCASE = "run.testcase.test.testcase";
    public static final String KEY_OPTION_OUTPUT_FOLDER = "run.testcase.test.output.folder";
    public static final String KEY_OPTION_HOST = "run.testcase.test.host";

    public RunTestcaseTest() {
        try {
            this.setType(TypeFactory.getInstance().getType(KEY));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void doTest() throws Exception {
        String location;
        String operation;
        File testcaseHome = (File)this.getOptionValue(KEY_OPTION_TESTCASE_HOME);
        File operationHome = new File(testcaseHome, operation = (String)this.getOptionValue(KEY_OPTION_OPERATION));
        if (!operationHome.exists()) {
            try {
                File idFile = new File(testcaseHome, ".synchronous.id");
                RunTestcaseTest.assertTrue((String)("Testcase ID file '" + idFile.getAbsolutePath() + "' does not exists"), (boolean)idFile.exists());
                HashMap ids = UniqueIdService.loadUniqueIds((File)idFile);
                String id = (String)ids.get(operation);
                RunTestcaseTest.assertFalse((String)("ID for operation '" + operation + "' does not exists"), (id == null ? 1 : 0) != 0);
                operationHome = new File(testcaseHome, id);
            }
            catch (WrongIDFileVersionException e) {
                e.printStackTrace();
            }
        }
        RunTestcaseTest.assertTrue((String)("Operation home '" + operationHome.getAbsolutePath() + "' does not exists"), (boolean)operationHome.exists());
        File templateFile = new File(operationHome, "template.xml");
        RunTestcaseTest.assertTrue((String)("Template file for operation '" + operation + "' does not exists"), (boolean)templateFile.exists());
        SynchronousTestcaseTemplate template = new SynchronousTestcaseTemplate(templateFile);
        String testcase = (String)this.getOptionValue(KEY_OPTION_TESTCASE);
        SynchronousTestcase test = new SynchronousTestcase(testcase, template, operationHome);
        test.clearResultObjects();
        File outputFolder = (File)this.getOptionValue(KEY_OPTION_OUTPUT_FOLDER);
        if (outputFolder != null) {
            test.setTraceFolder(outputFolder);
        }
        try {
            FileUtilities.deleteAllFiles((File)test.getTraceFolder());
        }
        catch (IOException e) {
            throw new IOException("Could not clear/delete 'Output Folder' " + test.getTraceFolder().getAbsolutePath());
        }
        String host = (String)this.getOptionValue(KEY_OPTION_HOST);
        if (host != null) {
            URL url = new URL(test.getLocation());
            int port = url.getPort();
            int index = host.indexOf(58);
            if (index != -1) {
                String portString = host.substring(index + 1);
                port = Integer.parseInt(portString);
                host = host.substring(0, index);
            }
            location = new URL(url.getProtocol(), host, port, url.getFile()).toString();
        } else {
            location = test.getLocation();
        }
        test.setAdapterInfoHome(test.getHome());
        SOAPResponse response = HttpClient.performRequest((SynchronousTestcaseRequest)RequestPool.getInstance().createRequest((AbstractSynchronousTestcase)test), (String)location);
        if (response instanceof SOAPFault) {
            RunTestcaseTest.assertFalse((String)((SOAPFault)response).getMessage(), (boolean)true);
        }
        test.setResponse(response, false);
    }

    public String getRecommendedCompareType() {
        return "TestcaseCompare";
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption outputFolder = (FileOption)this.getOption(KEY_OPTION_OUTPUT_FOLDER);
        File defaultValue = new File(testFolder, "${run.testcase.test.operation}/${key.option.test.name}");
        outputFolder.setDependencyString(defaultValue.getAbsolutePath());
        outputFolder.setDefaultValue((Object)defaultValue);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof TestcaseCompare)) continue;
                Option testFile = (Option)compare.getOptions().get("xml.compare.test.file");
                testFile.setDependencyString("${run.testcase.test.output.folder}");
                testFile.setDefaultValue((Object)new File("${run.testcase.test.output.folder}"));
            }
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof TestcaseCompare)) continue;
                FileOption referenceFileOption = (FileOption)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(referenceFolder, "${run.testcase.test.operation}/${key.option.test.name}");
                referenceFileOption.setDependencyString(defaultValue.getAbsolutePath());
                referenceFileOption.setDefaultValue((Object)defaultValue);
            }
        }
    }

    public void removeSourceData() {
        String operation;
        File testcaseHome = (File)this.getOptionValue(KEY_OPTION_TESTCASE_HOME);
        if (testcaseHome != null && (operation = (String)this.getOptionValue(KEY_OPTION_OPERATION)) != null && (testcaseHome = new File(testcaseHome, operation)).exists()) {
            File[] adapterFiles;
            File adapterTemplatesData;
            File request;
            String testcase = (String)this.getOptionValue(KEY_OPTION_TESTCASE);
            File testcaseFile = new File(testcaseHome, testcase + ".testcase");
            if (testcaseFile.exists()) {
                testcaseFile.delete();
            }
            if ((request = new File(testcaseHome, testcase + ".request")).exists()) {
                request.delete();
            }
            File template = new File(testcaseHome, "template.xml");
            File[] testcases = FileUtilities.getFileList((File)testcaseHome, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".testcase");
                }
            });
            if (template.exists() && testcases.length == 0) {
                template.delete();
            }
            if ((adapterTemplatesData = new File(testcaseHome, testcase + ".adapters")).exists()) {
                adapterTemplatesData.delete();
            }
            if ((adapterFiles = FileUtilities.getFileList((File)testcaseHome, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".adapters");
                }
            })).length == 0) {
                File adapterIds;
                File adapterTemplates = new File(testcaseHome, "adapter.templates.zip");
                if (adapterTemplates.exists()) {
                    adapterTemplates.delete();
                }
                if ((adapterIds = new File(testcaseHome, "adapter.template.ids")).exists()) {
                    adapterIds.delete();
                }
            }
            if (testcaseHome.listFiles().length == 1) {
                FileUtilities.silentDeleteDirectory((File)testcaseHome);
            }
            Utilities.deleteEmptyParents((File)testcaseHome);
        }
    }

    public void removeOutputData() {
        File outputFolder = (File)this.getOptionValue(KEY_OPTION_OUTPUT_FOLDER);
        if (outputFolder != null && outputFolder.exists()) {
            FileUtilities.silentDeleteDirectory((File)outputFolder);
            Utilities.deleteEmptyParents((File)outputFolder);
        }
    }

    public void readSources(NodeList sources, boolean inherited) {
        int length = sources.getLength();
        for (int i = 0; i < length; ++i) {
            File value;
            Element source = (Element)sources.item(i);
            String name = source.getAttribute("name");
            String valueStr = source.getAttribute("value");
            Option option = null;
            if (name.equals("testcaseHome") || name.equals("testcase.home")) {
                option = this.getOption(KEY_OPTION_TESTCASE_HOME);
                value = ((FileOption)option).createValue(valueStr);
                option.setValue((Object)value);
            } else if (name.equals("operation")) {
                option = this.getOption(KEY_OPTION_OPERATION);
                option.setValue((Object)valueStr);
            } else if (name.equals("testcase")) {
                option = this.getOption(KEY_OPTION_TESTCASE);
                option.setValue((Object)valueStr);
            } else if (name.equals("output.folder")) {
                option = this.getOption(KEY_OPTION_OUTPUT_FOLDER);
                value = ((FileOption)option).createValue(valueStr);
                this.getOption(KEY_OPTION_OUTPUT_FOLDER).setValue((Object)value);
            } else if (name.equals("host")) {
                option = this.getOption(KEY_OPTION_HOST);
                option.setValue((Object)valueStr);
            }
            if (option == null) continue;
            option.setInherited(inherited);
        }
    }

    public void prepareCompareType(ResultCompare compare) {
        if (compare instanceof TestcaseCompare) {
            StringOption nameOption = (StringOption)compare.getOptions().get("key.option.result.compare.name");
            String defaultName = "Compare run of ${key.option.test.name}";
            nameOption.addDependency("key.option.test.name");
            nameOption.setDependencyString(defaultName);
            nameOption.setDefaultValue((Object)defaultName);
            FileOption testFileOption = (FileOption)compare.getOptions().get("xml.compare.test.file");
            testFileOption.addDependency(KEY_OPTION_OUTPUT_FOLDER);
            testFileOption.setDependencyString("${run.testcase.test.output.folder}");
            FileOption output = (FileOption)this.getOption(KEY_OPTION_OUTPUT_FOLDER);
            testFileOption.setDefaultValue((Object)(output.getValue() == null ? (File)output.getDefaultValue() : (File)output.getValue()));
            FileOption referenceFileOption = (FileOption)compare.getOptions().get("xml.compare.reference.file");
            referenceFileOption.addDependency(KEY_OPTION_OPERATION);
            referenceFileOption.addDependency("key.option.test.name");
            referenceFileOption.setDependencyString("${run.testcase.test.operation}/${key.option.test.name}");
        }
    }

    public void moveSources(File oldSourceFolder, File newSourceFolder) {
        File testcaseHome = (File)this.getOptionValue(KEY_OPTION_TESTCASE_HOME);
        if (testcaseHome != null) {
            File oldOperationHome;
            String operation = (String)this.getOptionValue(KEY_OPTION_OPERATION);
            if (operation != null && (oldOperationHome = new File(testcaseHome, operation)).exists()) {
                File namespacesList;
                File adapterIds;
                File adapterTemplates;
                File adapterTemplatesData;
                File request;
                String testcase = (String)this.getOptionValue(KEY_OPTION_TESTCASE);
                File testcaseFile = new File(oldOperationHome, testcase + ".testcase");
                if (testcaseFile.exists()) {
                    this.moveFile(oldSourceFolder, newSourceFolder, testcaseFile);
                }
                if ((request = new File(oldOperationHome, testcase + ".request")).exists()) {
                    this.moveFile(oldSourceFolder, newSourceFolder, request);
                }
                boolean move = FileUtilities.getFileList((File)oldOperationHome, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".testcase");
                    }
                }).length == 0;
                File template = new File(oldOperationHome, "template.xml");
                if (template.exists()) {
                    if (move) {
                        this.moveFile(oldSourceFolder, newSourceFolder, template);
                    } else {
                        this.copyFile(oldSourceFolder, newSourceFolder, template);
                    }
                }
                if ((adapterTemplatesData = new File(oldOperationHome, testcase + ".adapters")).exists()) {
                    if (move) {
                        this.moveFile(oldSourceFolder, newSourceFolder, adapterTemplatesData);
                    } else {
                        this.copyFile(oldSourceFolder, newSourceFolder, adapterTemplatesData);
                    }
                }
                if ((adapterTemplates = new File(oldOperationHome, "adapter.templates.zip")).exists()) {
                    if (move) {
                        this.moveFile(oldSourceFolder, newSourceFolder, adapterTemplates);
                    } else {
                        this.copyFile(oldSourceFolder, newSourceFolder, adapterTemplates);
                    }
                }
                if ((adapterIds = new File(oldOperationHome, "adapter.template.ids")).exists()) {
                    if (move) {
                        this.moveFile(oldSourceFolder, newSourceFolder, adapterIds);
                    } else {
                        this.copyFile(oldSourceFolder, newSourceFolder, adapterIds);
                    }
                }
                if ((namespacesList = new File(oldOperationHome, "namespaces.list")).exists()) {
                    if (move) {
                        this.moveFile(oldSourceFolder, newSourceFolder, namespacesList);
                    } else {
                        this.copyFile(oldSourceFolder, newSourceFolder, namespacesList);
                    }
                }
                Utilities.deleteEmptyParents((File)oldOperationHome);
            }
            this.getOption(KEY_OPTION_TESTCASE_HOME).setValue((Object)newSourceFolder);
        }
    }

    public void resetOutputFolder(File oldOutputFolder, File newOutputFolder) {
        File outputFolder = (File)((FileOption)this.getOption(KEY_OPTION_OUTPUT_FOLDER)).getValue();
        String oldPath = FileUtilities.getAbsolutePath((File)oldOutputFolder).replace('\\', '/');
        String newPath = FileUtilities.getAbsolutePath((File)newOutputFolder).replace('\\', '/');
        if (outputFolder.isAbsolute()) {
            String outputPath = FileUtilities.getAbsolutePath((File)outputFolder).replace('\\', '/');
            outputPath = outputPath.replace(oldPath, newPath);
            this.getOption(KEY_OPTION_OUTPUT_FOLDER).setValue((Object)new File(outputPath));
        }
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                File testFile;
                if (!(compare instanceof TestcaseCompare) || !(testFile = (File)((FileOption)compare.getOptions().get("xml.compare.test.file")).getValue()).isAbsolute()) continue;
                String testPath = FileUtilities.getAbsolutePath((File)testFile).replace('\\', '/');
                testPath = testPath.replace(oldPath, newPath);
                ((Option)compare.getOptions().get("xml.compare.test.file")).setValue((Object)new File(testPath));
            }
        }
    }

    private File moveFile(File oldSourceFolder, File newSourceFolder, File oldFile) {
        String relativPath = FileUtilities.getRelativePath((File)oldFile, (File)oldSourceFolder);
        File result = new File(newSourceFolder, relativPath);
        if (result.exists()) {
            result.delete();
        } else {
            result.getParentFile().mkdirs();
        }
        if (!oldFile.renameTo(result)) {
            System.out.println("Could not move " + oldFile + " to " + result);
            result = null;
        }
        return result;
    }

    private boolean copyFile(File oldSourceFolder, File newSourceFolder, File oldFile) {
        boolean result;
        String relativPath = FileUtilities.getRelativePath((File)oldFile, (File)oldSourceFolder);
        File newFile = new File(newSourceFolder, relativPath);
        if (newFile.exists()) {
            newFile.delete();
        } else {
            newFile.getParentFile().mkdirs();
        }
        try {
            FileUtilities.copyFile((File)oldFile, (File)newFile);
            result = true;
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    protected void createOptions() {
        StringOption testcase = new StringOption("Testcase", KEY_OPTION_TESTCASE, 0);
        testcase.setRequired(true);
        this.addOption(KEY_OPTION_TESTCASE, (Option)testcase);
        FileOption testcaseHome = new FileOption("Testcase home", KEY_OPTION_TESTCASE_HOME, 1);
        testcaseHome.setRequired(true);
        testcaseHome.setDirectory(true);
        this.addOption(KEY_OPTION_TESTCASE_HOME, (Option)testcaseHome);
        StringOption operation = new StringOption("Operation", KEY_OPTION_OPERATION, 2);
        operation.setRequired(true);
        this.addOption(KEY_OPTION_OPERATION, (Option)operation);
        FileOption fileOption = new FileOption("Output folder", KEY_OPTION_OUTPUT_FOLDER, new File("${run.testcase.test.operation}/${key.option.test.name}"), 3);
        this.addOption(KEY_OPTION_OUTPUT_FOLDER, (Option)fileOption);
        fileOption.addDependency(KEY_OPTION_OPERATION);
        fileOption.addDependency("key.option.test.name");
        fileOption.setDependencyString("${run.testcase.test.operation}/${key.option.test.name}");
        fileOption.setRequired(true);
        fileOption.setDirectory(true);
        this.addOption(KEY_OPTION_HOST, (Option)new StringOption("Host", KEY_OPTION_HOST, 4));
        String defaultName = "${run.testcase.test.testcase}";
        this.getNameOption().addDependency(KEY_OPTION_TESTCASE);
        this.getNameOption().setDependencyString(defaultName);
        this.getNameOption().setDefaultValue((Object)defaultName);
    }

    static {
        HttpsUtil.initialize();
    }
}

