/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks.test;

import ch.e2e.ant.tasks.test.TestTask;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JUnitViewTask
extends Task {
    private String test;
    private AntClassLoader classLoader;
    private CommandlineJava commandline;
    boolean reloading;

    public void setTest(String test) {
        this.test = test;
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    public Path createClasspath() {
        return this.getCommandline().createClasspath(this.getProject()).createPath();
    }

    public void execute() throws BuildException {
        if (this.test == null) {
            throw new BuildException("Attribute test must be defined.");
        }
        try {
            if (this.classLoader == null) {
                this.createClassLoader();
            }
            Class<?> testClass = Class.forName(this.test);
            Class<?> junitTestClass = Class.forName("ch.e2e.ant.builder.tasks.JUnitTest");
            TestTask test = (TestTask)junitTestClass.newInstance();
            test.doTest(testClass);
        }
        catch (Exception e) {
            this.log("Caught a " + e.getClass().getName() + ": " + e.getMessage(), 3);
            throw new BuildException((Throwable)e);
        }
    }

    private void createClassLoader() {
        Path userClasspath = this.getCommandline().getClasspath();
        if (userClasspath != null && (this.reloading || this.classLoader == null)) {
            Path classpath = (Path)userClasspath.clone();
            this.classLoader = this.getProject().createClassLoader(classpath);
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.setThreadContextLoader();
        }
    }

    private CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
        }
        return this.commandline;
    }
}

