/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.CounterPanel;
import ch.e2e.ant.gui.junit.E2ETestListener;
import ch.e2e.ant.gui.junit.FailureDetailView;
import ch.e2e.ant.gui.junit.FailureListCellRenderer;
import ch.e2e.ant.gui.junit.JUnitFailureRunView;
import ch.e2e.ant.gui.junit.JUnitGuiRegistry;
import ch.e2e.ant.gui.junit.JUnitHierarchyRunView;
import ch.e2e.ant.gui.junit.JUnitProgressBar;
import ch.e2e.ant.gui.junit.JUnitStatusLine;
import ch.e2e.event.EventController;
import ch.e2e.test.E2ETask;
import ch.e2e.test.junit.ListTestRunContext;
import ch.e2e.test.junit.TestUnit;
import ch.e2e.test.junit.TreeTestRunContext;
import ch.e2e.test.junit.event.JUnitTestStartingEvent;
import ch.e2e.test.junit.event.StartTestEvent;
import java.util.EventObject;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;

public class JUnitTestListener
extends E2ETestListener
implements ListTestRunContext,
TreeTestRunContext {
    private DefaultListModel listModel = new DefaultListModel();
    private ListCellRenderer listCellRenderer = new FailureListCellRenderer();

    protected JUnitTestListener() {
    }

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public TestUnit getTreeRoot() {
        return this.getRoot();
    }

    @Override
    public void testStarting(Test test, TestResult result) {
        JUnitProgressBar progressBar;
        super.testStarting(test, this.getResult());
        EventController.fire((EventObject)new JUnitTestStartingEvent((Object)this));
        int total = test.countTestCases();
        CounterPanel counterPanel = (CounterPanel)JUnitGuiRegistry.getInstance().getGui(CounterPanel.class.getName());
        if (counterPanel != null) {
            counterPanel.reset();
            counterPanel.setTotal(total);
            counterPanel.setRunValue(0);
        }
        if ((progressBar = (JUnitProgressBar)JUnitGuiRegistry.getInstance().getGui(JUnitProgressBar.class.getName())) != null) {
            progressBar.reset();
            progressBar.start(total);
        }
        FailureDetailView failureView = (FailureDetailView)JUnitGuiRegistry.getInstance().getGui(FailureDetailView.class.getName());
        failureView.clear();
        this.listModel.clear();
        JUnitFailureRunView runFailureView = (JUnitFailureRunView)JUnitGuiRegistry.getInstance().getGui(JUnitFailureRunView.class.getName());
        runFailureView.setRunContext(this);
        JUnitHierarchyRunView runHierarchyView = (JUnitHierarchyRunView)JUnitGuiRegistry.getInstance().getGui(JUnitHierarchyRunView.class.getName());
        runHierarchyView.setRunContext(this);
        this.showStatus("Running ...", 1);
    }

    @Override
    public void testStarting(TestUnit root, TestResult result) {
        JUnitProgressBar progressBar;
        super.testStarting(this.getRoot(), this.getResult());
        EventController.fire((EventObject)new JUnitTestStartingEvent((Object)this));
        int total = this.getRoot().countTestCases();
        CounterPanel counterPanel = (CounterPanel)JUnitGuiRegistry.getInstance().getGui(CounterPanel.class.getName());
        if (counterPanel != null) {
            counterPanel.reset();
            counterPanel.setTotal(total);
            counterPanel.setRunValue(0);
        }
        if ((progressBar = (JUnitProgressBar)JUnitGuiRegistry.getInstance().getGui(JUnitProgressBar.class.getName())) != null) {
            progressBar.reset();
            progressBar.start(total);
        }
        FailureDetailView failureView = (FailureDetailView)JUnitGuiRegistry.getInstance().getGui(FailureDetailView.class.getName());
        failureView.clear();
        this.listModel.clear();
        JUnitFailureRunView runFailureView = (JUnitFailureRunView)JUnitGuiRegistry.getInstance().getGui(JUnitFailureRunView.class.getName());
        runFailureView.setRunContext(this);
        JUnitHierarchyRunView runHierarchyView = (JUnitHierarchyRunView)JUnitGuiRegistry.getInstance().getGui(JUnitHierarchyRunView.class.getName());
        runHierarchyView.setRunContext(this);
        this.showStatus("Running ...", 1);
    }

    @Override
    public void showStatus(String message, int type) {
        JUnitStatusLine statusLine = (JUnitStatusLine)JUnitGuiRegistry.getInstance().getGui(JUnitStatusLine.class.getName());
        if (statusLine != null) {
            statusLine.showStatus(message, type);
        }
    }

    @Override
    public void testFinished(Test test, TestResult result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public void addError(Test test, Throwable throwable) {
        super.addError(test, throwable);
        CounterPanel counterPanel = (CounterPanel)JUnitGuiRegistry.getInstance().getGui(CounterPanel.class.getName());
        counterPanel.setErrorValue(this.getResult().errorCount());
        this.testFailed(test, throwable);
        this.getRoot().addError(test);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        super.addError(test, (Throwable)assertionFailedError);
        CounterPanel counterPanel = (CounterPanel)JUnitGuiRegistry.getInstance().getGui(CounterPanel.class.getName());
        counterPanel.setFailureValue(this.getResult().failureCount());
        this.testFailed(test, (Throwable)assertionFailedError);
    }

    @Override
    public void endTest(Test test) {
        super.endTest(test);
        final int runCount = this.getResult().runCount() - this.getTaskCount();
        final boolean successful = this.getResult().wasSuccessful();
        this.getRoot().addRunTest(test);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CounterPanel counterPanel = (CounterPanel)JUnitGuiRegistry.getInstance().getGui(CounterPanel.class.getName());
                counterPanel.setRunValue(runCount);
                JUnitProgressBar progressBar = (JUnitProgressBar)JUnitGuiRegistry.getInstance().getGui(JUnitProgressBar.class.getName());
                progressBar.step(runCount, successful);
                SwingUtilities.updateComponentTreeUI(progressBar);
            }
        });
    }

    @Override
    public void startTest(Test test) {
        EventController.fire((EventObject)new StartTestEvent((Object)this, test));
        if (test instanceof E2ETask) {
            this.showStatus("Running Task '" + test.toString() + "'.", 1);
        } else {
            this.showStatus("Running Test '" + test.toString() + "'.", 1);
        }
    }

    public void testSelected(Object value) {
        if (value != null) {
            if (value instanceof Test) {
                this.showFailureDetail((Test)value);
            } else if (value instanceof TestFailure) {
                FailureDetailView failureView = (FailureDetailView)JUnitGuiRegistry.getInstance().getGui(FailureDetailView.class.getName());
                failureView.showFailure(((TestFailure)value).trace());
            }
        }
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    private void showFailureDetail(Test test) {
        FailureDetailView failureView = (FailureDetailView)JUnitGuiRegistry.getInstance().getGui(FailureDetailView.class.getName());
        if (test != null) {
            ListModel failures = this.getListModel();
            for (int i = 0; i < failures.getSize(); ++i) {
                TestFailure failure = (TestFailure)failures.getElementAt(i);
                if (failure.failedTest() != test) continue;
                failureView.showFailure(failure.trace());
                return;
            }
        }
        failureView.clear();
    }

    @Override
    public void testFailed(final Test test, final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JUnitTestListener.this.appendFailure(test, t);
            }
        });
    }

    private void appendFailure(Test test, Throwable t) {
        this.listModel.addElement(new TestFailure(test, t));
    }
}

