/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.input.DirectoryList;
import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.filechooser.DirectoryField;
import ch.e2e.swing.filechooser.E2EFileChooser;
import ch.e2e.swing.model.Directory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DirectoryInputField
extends InputElement
implements ActionListener {
    private E2EFileChooser dirChooser;
    private JPanel inputPanel;
    private DirectoryField directoryField;
    private boolean browseButton = true;
    private File root;
    private boolean canBeEmpty = true;
    private DirectoryChooserDefinition dirChooserDefinition = new DirectoryChooserDefinition();

    public DirectoryInputField() {
        this.setFill("horizontal");
    }

    public DirectoryField getField() {
        return this.directoryField;
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
    }

    public void addDirectoryListener(DirectoryList field) {
        this.directoryField.addDirectorySelectedListener((DirectorySelectedListener)field);
        field.addDirectorySelectedListener((DirectorySelectedListener)this.directoryField);
    }

    public void setBrowseButton(boolean browseButton) {
        this.browseButton = browseButton;
    }

    public DirectoryChooserDefinition createDirectoryChooser() {
        return this.dirChooserDefinition;
    }

    @Override
    public JComponent getGuiElement() {
        if (this.inputPanel == null) {
            this.inputPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = this.browseButton ? 1 : 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            this.directoryField = new DirectoryField();
            this.directoryField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    String text = DirectoryInputField.this.directoryField.getText();
                    if (text.length() > 0) {
                        DirectoryInputField.this.directoryField.setSelectionStart(0);
                        DirectoryInputField.this.directoryField.setSelectionEnd(text.length());
                    }
                }
            });
            this.directoryField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryInputField.this.fireAction(e);
                }
            });
            this.inputPanel.add((Component)this.directoryField, c);
            this.inputPanel.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DirectoryInputField.this.directoryField.requestFocus();
                }
            });
            if (this.browseButton) {
                JButton browse = new JButton("...");
                c.weightx = 0.0;
                c.gridwidth = 0;
                c.insets = new Insets(0, 5, 0, 0);
                browse.addActionListener(this);
                this.inputPanel.add((Component)browse, c);
            }
            this.directoryField.addInputFieldListener(new InputFieldListener(){

                public void inputFieldChanged(InputFieldEvent e) {
                    DirectoryInputField.this.fireInputFieldChanged(DirectoryInputField.this);
                }
            });
        }
        return this.inputPanel;
    }

    public void setRoot(File root) {
        this.root = root;
        this.directoryField.setRoot(root);
    }

    public void setSelectedDirectory(File directory) {
        this.directoryField.setSelectedDirectory(directory);
    }

    @Override
    public String getValue() {
        String result = null;
        Directory directory = this.directoryField.getSelectedDirectory();
        if (directory != null && directory.getDir() != null) {
            String string = result = this.root == null ? directory.getDir().getAbsolutePath() : FileUtilities.getRelativePath((File)directory.getDir(), (File)this.root);
            if (!this.canBeEmpty && result.length() == 0) {
                result = null;
            }
        }
        if (result != null && result.endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.directoryField.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.directoryField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Directory directory;
        File startDir;
        File selectedDir;
        if (this.dirChooser == null) {
            JFrame dialogParent = ConfigurationTools.getInstance().getDialogParent();
            this.dirChooser = new E2EFileChooser((Frame)dialogParent, this.dirChooserDefinition.frameTitle, this.dirChooserDefinition.title, this.dirChooserDefinition.subtitle);
            if (dialogParent != null) {
                this.dirChooser.setMinimumWidth(dialogParent.getSize().width - 10);
                this.dirChooser.setMinimumHeight(dialogParent.getSize().height - 10);
            }
        }
        if ((selectedDir = this.dirChooser.selectDirectory(startDir = (directory = this.directoryField.getSelectedDirectory()).getDir())) != null) {
            this.directoryField.setSelectedDirectory(selectedDir);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.directoryField.setEnabled(enabled);
    }

    public class DirectoryChooserDefinition {
        private String frameTitle = ConfigurationTools.getInstance().getTranslation("director.chooser.frametitle");
        private String title = ConfigurationTools.getInstance().getTranslation("director.chooser.title");
        private String subtitle = ConfigurationTools.getInstance().getTranslation("director.chooser.subtitle");

        public void setFrameTitle(String frameTitle) {
            this.frameTitle = frameTitle;
        }

        public void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

