/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.InputCheckBox;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CheckBox
extends InputElement
implements InputFieldListener {
    private InputCheckBox checkBox;
    private String label = "";
    private String icon;
    private boolean selected = false;
    private boolean updateSelection = true;
    private boolean enabled = true;
    private String value = "true";

    public void setValue(String value) {
        this.value = value;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void updateLabel(String label) {
        if (!this.label.equals(label)) {
            this.label = label;
            this.checkBox.setText(label);
        }
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void updateIcon(String icon) {
        if (this.icon == null || !this.icon.equals(icon)) {
            this.icon = icon;
            this.checkBox.setIcon((Icon)ImageLoader.loadIcon((String)icon, (boolean)true));
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void updateSelected(boolean newSelected) {
        if (this.updateSelection && newSelected ^ this.selected) {
            this.selected = newSelected;
            if (this.checkBox != null) {
                this.checkBox.setSelected(newSelected);
            }
        }
    }

    public void setUpdateSelection(boolean updateSelection) {
        this.updateSelection = updateSelection;
    }

    @Override
    public JComponent getGuiElement() {
        if (this.checkBox == null) {
            this.checkBox = new InputCheckBox(this.label);
            if (this.icon != null) {
                this.checkBox.setIcon((Icon)ImageLoader.loadIcon((String)this.icon, (boolean)true));
            }
            this.checkBox.setSelected(this.selected);
            this.checkBox.addInputFieldListener((InputFieldListener)this);
        }
        return this.checkBox;
    }

    @Override
    public String getValue() {
        return this.checkBox.isSelected() ? this.value : null;
    }

    public void inputFieldChanged(InputFieldEvent event) {
        this.fireInputFieldChanged(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.checkBox.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void requestFocus() {
        this.checkBox.requestFocus();
    }

    @Override
    public void setEditable(boolean editable) {
        this.checkBox.setEditable(editable);
    }
}

