/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.display;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.types.AbstractGuiElement;
import ch.e2e.resource.ImageLoader;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Image
extends AbstractGuiElement {
    private String filename;
    private JLabel icon = null;
    private boolean opaque;
    private Color background;

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void updateFilename(String filename) {
        if (!this.filename.equals(filename)) {
            this.filename = filename;
            this.icon.setIcon(ImageLoader.loadIcon((String)filename, (boolean)true));
        }
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    public void updateBackground(Color background) {
        if (this.background == null || !this.background.equals(background)) {
            this.background = background;
            this.icon.setBackground(background);
        }
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public void updateOpaque(boolean opaque) {
        if (this.opaque ^ opaque) {
            this.opaque = opaque;
            this.icon.setOpaque(opaque);
        }
    }

    public int getWidth() {
        return this.icon.getIcon().getIconWidth();
    }

    @Override
    public JComponent getGuiElement() {
        if (this.icon == null) {
            if (this.filename == null) {
                throw new ConfigurationParseException("The 'filename' attribute must be set for an icon element.");
            }
            this.icon = new JLabel(ImageLoader.loadIcon((String)this.filename, (boolean)true));
            this.icon.setOpaque(this.opaque);
            if (this.background != null) {
                this.icon.setBackground(this.background);
            }
        }
        return this.icon;
    }
}

