/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.condition;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.ConfigurationTask;
import ch.e2e.ant.gui.configuration.types.condition.ConditionElement;
import ch.e2e.resource.Properties;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Property
implements ConditionElement,
ConfigurationTask {
    private String os;
    private String name;
    private String value;
    private String file;
    private String resource;
    private String ifString;
    private String unless;
    private String prefix;

    @Override
    public void execute(Properties properties) throws ConfigurationParseException {
        Map propertiesToAdd = this.getProperties(properties);
        if (propertiesToAdd != null) {
            properties.putAll(propertiesToAdd);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public String getValue() {
        return this.value;
    }

    public void setIf(String ifString) {
        this.ifString = ifString;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void setFile(String file) {
        if (this.name != null) {
            throw new ConfigurationParseException("Only the name or file attribute of the property element can be set.");
        }
        this.file = file;
    }

    public void setName(String name) {
        if (this.file != null) {
            throw new ConfigurationParseException("Only the name or file attribute of the property element can be set.");
        }
        this.name = name;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map getProperties(Properties properties) {
        Properties result = null;
        if (this.name == null && this.file == null && this.resource == null) {
            throw new ConfigurationParseException("The name, resource or file attribute of the property element must be set.");
        }
        if (ConfigurationTools.checkOs(this.os) && this.checkIfUnless(properties)) {
            if (this.file == null && this.resource == null) {
                result = new HashMap();
                if (this.value != null) {
                    result.put(this.name, this.value);
                }
            } else {
                result = this.file == null ? new Properties(this.resource) : new Properties(new File(this.file));
                if (this.prefix != null) {
                    if (!this.prefix.endsWith(".")) {
                        this.prefix = this.prefix + ".";
                    }
                    for (String name : result.keySet()) {
                        String value = (String)result.get(name);
                        result.remove(name);
                        result.put(this.prefix + name, value);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean check(Properties properties) {
        if (this.name == null && this.os == null) {
            throw new ConfigurationParseException("The attribute 'name' or 'os' in the property element must be set.");
        }
        boolean result = false;
        if (ConfigurationTools.checkOs(this.os)) {
            result = properties.containsKey((Object)this.name);
        }
        return result;
    }

    public boolean checkIfUnless(Properties properties) {
        boolean result = true;
        if (this.unless != null) {
            result = !properties.containsKey((Object)this.unless);
        } else if (this.ifString != null) {
            result = properties.containsKey((Object)this.ifString);
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Property) {
            result = this.name == null ? super.equals(obj) : this.name.equals(((Property)obj).name);
        }
        return result;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }
}

