/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui;

import ch.e2e.ant.InputRequest;
import ch.e2e.ant.MultipleChoiceInputRequest;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.MultiLineLabel;
import ch.e2e.swing.border.SelectSideEtchedBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.tools.ant.input.InputHandler;

public class AntInputDialog
extends ModalDialog
implements InputHandler {
    private static HashMap inputDialogs = new HashMap();
    private MultiLineLabel question;
    private ButtonGroup bg;
    private JTextField userInput;

    public AntInputDialog(JFrame owner) {
        super((Frame)owner, 3);
    }

    public static AntInputDialog getInstance() {
        return AntInputDialog.getInstance(null);
    }

    public static AntInputDialog getInstance(JFrame owner) {
        AntInputDialog inputDialog = (AntInputDialog)((Object)inputDialogs.get(owner));
        if (inputDialog == null) {
            inputDialog = new AntInputDialog(owner);
            inputDialogs.put(owner, inputDialog);
        }
        return inputDialog;
    }

    public void handleInput(org.apache.tools.ant.input.InputRequest request) {
        do {
            this.reset(request);
            request.setInput(this.getUserInput());
        } while (!request.isInputValid());
    }

    private void reset(org.apache.tools.ant.input.InputRequest request) {
        this.removeAll();
        this.bg = null;
        this.createGui(request);
        this.doLayout();
    }

    private String getUserInput() {
        String s = null;
        int result = this.showDialog();
        if (result == 1) {
            s = this.bg == null ? this.userInput.getText() : this.bg.getSelection().getActionCommand();
        }
        return s;
    }

    private void createGui(org.apache.tools.ant.input.InputRequest request) {
        String questionStr = request.getPrompt();
        String defaultStr = null;
        if (request instanceof InputRequest) {
            defaultStr = ((InputRequest)request).getDefaultValue();
        }
        if (defaultStr == null) {
            int index = questionStr.indexOf("%DEFAULT%");
            if (index != -1) {
                defaultStr = questionStr.substring(index + 9, questionStr.length());
                questionStr = questionStr.substring(0, index - 1);
            } else {
                defaultStr = "";
            }
        }
        this.setLayout(new BorderLayout());
        this.question = new MultiLineLabel(questionStr);
        this.question.setBorder((Border)BorderFactory.createCompoundBorder((Border)new SelectSideEtchedBorder(4), BorderFactory.createEmptyBorder(10, 10, 5, 10)));
        this.add((Component)this.question, "North");
        if (request instanceof org.apache.tools.ant.input.MultipleChoiceInputRequest) {
            this.createMultipleChoiceInput(((org.apache.tools.ant.input.MultipleChoiceInputRequest)request).getChoices(), defaultStr);
        } else if (request instanceof MultipleChoiceInputRequest) {
            this.createMultipleChoiceInput(((MultipleChoiceInputRequest)request).getChoices(), defaultStr);
        } else {
            this.createUserInputField(defaultStr);
        }
    }

    protected void createMultipleChoiceInput(Vector valueList, String defaultStr) {
        this.setCancelButtonVisible(false);
        this.bg = new ButtonGroup();
        Enumeration values = valueList.elements();
        ArrayList<JRadioButton> choices = new ArrayList<JRadioButton>();
        boolean selected = false;
        while (values.hasMoreElements()) {
            String text = (String)values.nextElement();
            JRadioButton rb = new JRadioButton(text);
            rb.setActionCommand(text);
            choices.add(rb);
            this.bg.add(rb);
            if (defaultStr == null) continue;
            rb.setSelected(text.equals(defaultStr));
            selected = false;
        }
        if (choices.size() > 0 && !selected) {
            ((JRadioButton)choices.get(0)).setSelected(true);
        }
        JPanel choicePanel = new JPanel(new GridLayout(0, 2));
        choicePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        int length = choices.size();
        for (int i = 0; i < length; ++i) {
            choicePanel.add((JRadioButton)choices.get(i));
        }
        this.add(choicePanel, "Center");
    }

    private void createUserInputField(String defaultStr) {
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        JLabel input = new JLabel("Input:");
        input.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        center.add((Component)input, "North");
        this.userInput = new JTextField(30);
        this.userInput.setText(defaultStr);
        this.userInput.setCaretPosition(defaultStr.length());
        this.userInput.setSelectionStart(0);
        this.userInput.setSelectionEnd(defaultStr.length());
        center.add((Component)this.userInput, "Center");
        this.userInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntInputDialog.this.okDialog();
            }
        });
        this.add(center, "Center");
    }
}

