/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.ant.gui.AntConsole;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntProjectFactory {
    public static final String ANT_FILE = "ant.file";
    public static ArrayList<String> antProperties;

    public static Project createProject(File buildFile) {
        return AntProjectFactory.createProject(buildFile, (Properties)null);
    }

    public static Project createProject(File buildFile, AntConsole console) {
        return AntProjectFactory.createProject(buildFile, console, null);
    }

    public static Project createProject(File buildFile, AntConsole console, Properties properties) {
        Project project = AntProjectFactory.createProject(buildFile, properties);
        if (console != null) {
            project.addBuildListener((BuildListener)console);
        }
        return project;
    }

    public static Project createProject(File buildFile, Properties properties) {
        Project project = new Project();
        project.init();
        project.setUserProperty(ANT_FILE, FileUtilities.getAbsolutePath((File)buildFile));
        AntProjectFactory.fillProperties(project, properties);
        ProjectHelper.getProjectHelper().parse(project, (Object)buildFile);
        return project;
    }

    private static void fillProperties(Project project, Properties properties) {
        if (properties != null) {
            for (Object o : properties.keySet()) {
                String key = (String)o;
                project.setProperty(key, (String)properties.get((Object)key));
            }
        }
    }

    static {
        try {
            AntProjectFactory.class.getClassLoader().loadClass("org.apache.tools.ant.ProjectHelper");
            Class<?> projectClass = AntProjectFactory.class.getClassLoader().loadClass("org.apache.tools.ant.Project");
            projectClass.newInstance();
        }
        catch (Exception projectClass) {
            // empty catch block
        }
        antProperties = new ArrayList();
        Project project = new Project();
        project.init();
        for (Object o : project.getProperties().keySet()) {
            antProperties.add((String)o);
        }
        antProperties.add("basedir");
        antProperties.add(ANT_FILE);
    }
}

