/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTLiaison2;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TraXLiaison
implements XSLTLiaison2,
ErrorListener,
XSLTLoggerAware {
    private String factoryName = null;
    private TransformerFactory tfactory = null;
    private File stylesheet;
    private XSLTLogger logger;
    private EntityResolver entityResolver;
    private Transformer transformer;
    private Templates templates;
    private long templatesModTime;
    private URIResolver uriResolver;
    private Vector outputProperties = new Vector();
    private Vector params = new Vector();
    private Vector attributes = new Vector();

    public void setStylesheet(File stylesheet) throws Exception {
        if (this.stylesheet != null) {
            this.transformer = null;
            if (!this.stylesheet.equals(stylesheet) || stylesheet.lastModified() != this.templatesModTime) {
                this.templates = null;
            }
        }
        this.stylesheet = stylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File infile, File outfile) throws Exception {
        if (this.transformer == null) {
            this.createTransformer();
        }
        InputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(infile));
            fos = new BufferedOutputStream(new FileOutputStream(outfile));
            StreamResult res = new StreamResult(fos);
            res.setSystemId(JAXPUtils.getSystemId(outfile));
            Source src = this.getSource(fis, infile);
            this.transformer.transform(src, res);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignored) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source getSource(InputStream is, File infile) throws ParserConfigurationException, SAXException {
        void var3_6;
        Object var3_3 = null;
        if (this.entityResolver != null) {
            if (!this.getFactory().getFeature("http://javax.xml.transform.sax.SAXSource/feature")) throw new IllegalStateException("xcatalog specified, but parser doesn't support SAX");
            SAXParserFactory spFactory = SAXParserFactory.newInstance();
            spFactory.setNamespaceAware(true);
            XMLReader reader = spFactory.newSAXParser().getXMLReader();
            reader.setEntityResolver(this.entityResolver);
            SAXSource sAXSource = new SAXSource(reader, new InputSource(is));
        } else {
            StreamSource streamSource = new StreamSource(is);
        }
        var3_6.setSystemId(JAXPUtils.getSystemId(infile));
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readTemplates() throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        BufferedInputStream xslStream = null;
        try {
            xslStream = new BufferedInputStream(new FileInputStream(this.stylesheet));
            this.templatesModTime = this.stylesheet.lastModified();
            Source src = this.getSource(xslStream, this.stylesheet);
            this.templates = this.getFactory().newTemplates(src);
            Object var4_3 = null;
            if (xslStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (xslStream == null) throw throwable;
            ((InputStream)xslStream).close();
            throw throwable;
        }
        ((InputStream)xslStream).close();
    }

    private void createTransformer() throws Exception {
        if (this.templates == null) {
            this.readTemplates();
        }
        this.transformer = this.templates.newTransformer();
        this.transformer.setErrorListener(this);
        if (this.uriResolver != null) {
            this.transformer.setURIResolver(this.uriResolver);
        }
        int i = 0;
        while (i < this.params.size()) {
            String[] pair = (String[])this.params.elementAt(i);
            this.transformer.setParameter(pair[0], pair[1]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.outputProperties.size()) {
            String[] pair = (String[])this.outputProperties.elementAt(i2);
            this.transformer.setOutputProperty(pair[0], pair[1]);
            ++i2;
        }
    }

    private TransformerFactory getFactory() throws BuildException {
        if (this.tfactory != null) {
            return this.tfactory;
        }
        if (this.factoryName == null) {
            this.tfactory = TransformerFactory.newInstance();
        } else {
            try {
                Class<?> clazz = Class.forName(this.factoryName);
                this.tfactory = (TransformerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new BuildException(e);
            }
        }
        this.tfactory.setErrorListener(this);
        int i = 0;
        while (i < this.attributes.size()) {
            Object[] pair = (Object[])this.attributes.elementAt(i);
            this.tfactory.setAttribute((String)pair[0], pair[1]);
            ++i;
        }
        if (this.uriResolver != null) {
            this.tfactory.setURIResolver(this.uriResolver);
        }
        return this.tfactory;
    }

    public void setFactory(String name) {
        this.factoryName = name;
    }

    public void setAttribute(String name, Object value) {
        Object[] pair = new Object[]{name, value};
        this.attributes.addElement(pair);
    }

    public void setOutputProperty(String name, String value) {
        String[] pair = new String[]{name, value};
        this.outputProperties.addElement(pair);
    }

    public void setEntityResolver(EntityResolver aResolver) {
        this.entityResolver = aResolver;
    }

    public void setURIResolver(URIResolver aResolver) {
        this.uriResolver = aResolver;
    }

    public void addParam(String name, String value) {
        String[] pair = new String[]{name, value};
        this.params.addElement(pair);
    }

    public void setLogger(XSLTLogger l) {
        this.logger = l;
    }

    public void error(TransformerException e) {
        this.logError(e, "Error");
    }

    public void fatalError(TransformerException e) {
        this.logError(e, "Fatal Error");
        throw new BuildException("Fatal error during transformation", e);
    }

    public void warning(TransformerException e) {
        this.logError(e, "Warning");
    }

    private void logError(TransformerException e, String type) {
        if (this.logger == null) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            String systemid = locator.getSystemId();
            if (systemid != null) {
                String url = systemid;
                if (url.startsWith("file:///")) {
                    url = url.substring(8);
                }
                msg.append(url);
            } else {
                msg.append("Unknown file");
            }
            int line = locator.getLineNumber();
            if (line != -1) {
                msg.append(":" + line);
                int column = locator.getColumnNumber();
                if (column != -1) {
                    msg.append(":" + column);
                }
            }
        }
        msg.append(": " + type + "! ");
        msg.append(e.getMessage());
        if (e.getCause() != null) {
            msg.append(" Cause: " + e.getCause());
        }
        this.logger.log(msg.toString());
    }

    protected String getSystemId(File file) {
        return JAXPUtils.getSystemId(file);
    }

    public void configure(XSLTProcess xsltTask) {
        XMLCatalog xmlCatalog;
        XSLTProcess.Factory factory = xsltTask.getFactory();
        if (factory != null) {
            this.setFactory(factory.getName());
            Enumeration attrs = factory.getAttributes();
            while (attrs.hasMoreElements()) {
                XSLTProcess.Factory.Attribute attr = (XSLTProcess.Factory.Attribute)attrs.nextElement();
                this.setAttribute(attr.getName(), attr.getValue());
            }
        }
        if ((xmlCatalog = xsltTask.getXMLCatalog()) != null) {
            this.setEntityResolver(xmlCatalog);
            this.setURIResolver(xmlCatalog);
        }
        Enumeration props = xsltTask.getOutputProperties();
        while (props.hasMoreElements()) {
            XSLTProcess.OutputProperty prop = (XSLTProcess.OutputProperty)props.nextElement();
            this.setOutputProperty(prop.getName(), prop.getValue());
        }
    }
}

