/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tree.menu;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.DeleteWsdlEvent;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousFolderEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;
import javax.swing.tree.TreePath;

public class DeleteAsynchronousFolderExecuter
implements EventExecuter {
    private TraceViewer traceViewer;

    public DeleteAsynchronousFolderExecuter(TraceViewer traceViewer) {
        this.traceViewer = traceViewer;
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        TreePath path = ((DeleteAsynchronousFolderEvent)((Object)event)).getPath();
        AsynchronousFolder folder = (AsynchronousFolder)path.getLastPathComponent();
        String name = folder.getName();
        String question = this.traceViewer.getTranslation("async.folder.delete.question.message");
        question = StringTools.replaceProperty((String)question, (String)"async", (String)name);
        String title = this.traceViewer.getTranslation("async.folder.delete.question.title");
        title = StringTools.replaceProperty((String)title, (String)"async", (String)name);
        String subtitle = this.traceViewer.getTranslation("async.folder.delete.question.subtitle");
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)"async", (String)name)), (String)question)) {
            try {
                folder.getParent().delete((TestcaseObject)folder);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = this.traceViewer.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                    this.traceViewer.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                }
            }
            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this));
            TestcaseObject testcaseObject = this.traceViewer.getSynchronousRoot().get(name);
            if (testcaseObject != null) {
                EventController.fire((EventObject)new DeleteWsdlEvent(event.getSource(), new TreePath(testcaseObject.getPath())));
            }
        }
    }
}

