/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.testcase;

import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeEditor;
import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeInspector;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeInspector;
import com.jidesoft.marker.MarkerModel;
import java.io.StringReader;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlCodeEditor
extends AbstractXmlCodeEditor {
    public XmlCodeEditor(Boolean useCodeInspector) {
        super(useCodeInspector);
    }

    public AbstractXmlCodeInspector createCodeInspector() {
        return new XmlCodeInspector();
    }

    protected void addCodeInspector(AbstractXmlCodeInspector codeInspector) {
        this.addCodeInspector((CodeInspector)this.getCodeInspector());
    }

    protected void removeCodeInspector(AbstractXmlCodeInspector codeInspector) {
        this.removeCodeInspector((CodeInspector)this.getCodeInspector());
    }

    private static class XmlCodeInspector
    extends AbstractXmlCodeInspector
    implements CodeInspector {
        private final EventListenerList listeners = new EventListenerList();
        private XmlErrorHandler errorHandler;
        private boolean inpectionSuccessful = true;

        protected ErrorHandler createErrorHandler() {
            this.errorHandler = new XmlErrorHandler();
            return this.errorHandler;
        }

        public void inspect(CodeEditor codeEditor, DocumentEvent documentEvent, final MarkerModel markerModel) {
            markerModel.setAdjusting(true);
            markerModel.clearMarkers();
            String text = codeEditor.getText();
            if (!text.isEmpty()) {
                try {
                    this.errorHandler.setCodeEditor(codeEditor);
                    this.errorHandler.setMarkerModel(markerModel);
                    this.parse(new InputSource(new StringReader(text)));
                    this.inpectionSuccessful = true;
                    this.fireInspectionStatusChanged();
                }
                catch (SAXParseException e) {
                    this.inpectionSuccessful = false;
                    this.fireInspectionStatusChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    markerModel.setAdjusting(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void addCodeInspectionListener(AbstractXmlCodeInspector.CodeInspectionListener listener) {
            this.listeners.add(AbstractXmlCodeInspector.CodeInspectionListener.class, listener);
        }

        public void removeCodeInspectionListener(AbstractXmlCodeInspector.CodeInspectionListener listener) {
            this.listeners.remove(AbstractXmlCodeInspector.CodeInspectionListener.class, listener);
        }

        private void fireInspectionStatusChanged() {
            AbstractXmlCodeInspector.CodeInspectionEvent event = null;
            for (AbstractXmlCodeInspector.CodeInspectionListener listener : (AbstractXmlCodeInspector.CodeInspectionListener[])this.listeners.getListeners(AbstractXmlCodeInspector.CodeInspectionListener.class)) {
                if (event == null) {
                    event = new AbstractXmlCodeInspector.CodeInspectionEvent((AbstractXmlCodeInspector)this, this.inpectionSuccessful);
                }
                listener.inspectionStatusChanged(event);
            }
        }
    }

    public static class XmlErrorHandler
    implements ErrorHandler {
        private CodeEditor codeEditor;
        private MarkerModel markerModel;

        public void setCodeEditor(CodeEditor codeEditor) {
            this.codeEditor = codeEditor;
        }

        public void setMarkerModel(MarkerModel markerModel) {
            this.markerModel = markerModel;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.mark(exception, 1);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.mark(exception, 0);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.mark(exception, 0);
        }

        private void mark(SAXParseException exception, int markerType) {
            int start = this.codeEditor.getLineStartOffset(exception.getLineNumber() - 1) + exception.getColumnNumber() - 2;
            this.markerModel.addMarker(start, start + 1, markerType, exception.getLocalizedMessage());
        }
    }
}

