/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.importer;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.TransactionParticipant;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.ImportWsdlNameSelection;
import ch.e2e.builder.trace.importer.WSDLImport;
import ch.e2e.builder.trace.importer.WSDLImportTarget;
import ch.e2e.builder.traceviewer.execute.ImportWSDLTransaction;
import ch.e2e.builder.traceviewer.importer.TestcasesImporter;
import ch.e2e.builder.traceviewer.importer.WSDLImportDialog;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.util.StringTools;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;

public class WSDLImporter<T extends E2EBuilderModule>
implements EventExecuter {
    private static final String FILE_SEPARATOR_REGEX = "\\Q" + File.separator + "\\E";
    private static final String FILE_SEPARATOR_REPLACEMENT = ".";
    public static final String KEY_URL_IMPORT = "url_import";
    private WSDLImportDialog importDialog;
    private final T importTarget;

    public static <T extends E2EBuilderModule> WSDLImporter newInstance(T importTarget) {
        return new WSDLImporter<T>(importTarget);
    }

    private WSDLImporter(T importTarget) {
        this.importTarget = importTarget;
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        if (this.showImportDialog() == 1) {
            try {
                URL url = this.importDialog.getUrl();
                try {
                    this.importTarget.setProjectProperty(KEY_URL_IMPORT, (Object)url.toString());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (url.getFile().length() == 0) {
                    E2EBuilderInfoDialog.error((String)this.getInternalTitle("wsdl.import.from.url.error.url.not.valid.internaltitle"), (String)this.getSubtitle("wsdl.import.from.url.error.url.not.valid.subtitle"), (String)this.importTarget.getTranslation("wsdl.import.from.url.error.url.not.valid.message"));
                } else {
                    String projectName = this.createProjectName(WSDLImporter.getProjectName(url));
                    if (projectName != null) {
                        WSDLImport.Data data = null;
                        if (((WSDLImportTarget)this.importTarget).getSynchronousRoot().exists(projectName)) {
                            if (this.mergeTestcases(projectName)) {
                                data = new WSDLImport.Data((WSDLImportTarget)this.importTarget, projectName, url, true, this.importDialog.getNestingLevel(), this.importDialog.isUseCustomHost() ? this.importDialog.getCustomHost() : null);
                            }
                        } else {
                            data = new WSDLImport.Data((WSDLImportTarget)this.importTarget, projectName, url, false, this.importDialog.getNestingLevel(), this.importDialog.isUseCustomHost() ? this.importDialog.getCustomHost() : null);
                        }
                        if (data != null) {
                            TestcasesImporter testcasesImporter = this.importDialog.isImportTestcases() ? new TestcasesImporter((E2EBuilderModule)this.importTarget, data) : null;
                            EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new ImportWSDLTransaction((E2EBuilderModule)this.importTarget), (Object)data, (TransactionParticipant)testcasesImporter));
                        }
                    }
                }
            }
            catch (Exception e) {
                EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getMessage()));
                E2EBuilderInfoDialog.error((String)this.getInternalTitle(null), (String)this.getSubtitle(null), (String)e.getMessage());
            }
        }
    }

    protected String createProjectName(String name) {
        String projectName = null;
        if (name != null && (projectName = ImportWsdlNameSelection.getNewName((String)(name = new File(name).getPath().replaceAll(FILE_SEPARATOR_REGEX, FILE_SEPARATOR_REPLACEMENT)), (Iterable)((WSDLImportTarget)this.importTarget).getSynchronousRoot().getAllExistingWsdlFolder(), this.importTarget)) != null) {
            projectName = new File(projectName).getPath().replaceAll(FILE_SEPARATOR_REGEX, FILE_SEPARATOR_REPLACEMENT);
        }
        return projectName;
    }

    protected boolean mergeTestcases(String projectName) {
        String message = this.importTarget.getTranslation("wsdl.import.merge.question.message");
        message = StringTools.replaceProperty((String)message, (String)"project", (String)projectName);
        String title = this.importTarget.getTranslation("wsdl.import.merge.question.title");
        title = StringTools.replaceProperty((String)title, (String)"project", (String)projectName);
        String subtitle = this.importTarget.getTranslation("wsdl.import.merge.question.subtitle");
        subtitle = StringTools.replaceProperty((String)subtitle, (String)"project", (String)projectName);
        return E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)subtitle, (String)message);
    }

    private static String getProjectName(URL url) throws URISyntaxException {
        String projectName = null;
        if (url.getProtocol().startsWith("http")) {
            projectName = url.getPath();
            if (projectName.startsWith("/")) {
                projectName = projectName.substring(1);
            }
        } else if ("file".equals(url.getProtocol())) {
            projectName = new File(url.toURI()).getName();
            int index = projectName.lastIndexOf(FILE_SEPARATOR_REPLACEMENT);
            projectName = index < 0 ? projectName : projectName.substring(0, index);
        }
        return projectName;
    }

    private int showImportDialog() {
        if (this.importDialog == null) {
            this.importDialog = new WSDLImportDialog((E2EBuilderModule)this.importTarget);
        }
        return this.importDialog.showDialog();
    }

    protected String getInternalTitle(String key) {
        return this.importTarget.getTranslation(key, this.importTarget.getTranslation("wsdl.import.error.internaltitle"));
    }

    protected String getSubtitle(String key) {
        return this.importTarget.getTranslation(key, this.importTarget.getTranslation("wsdl.import.error.subtitle"));
    }
}

