/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.traceviewer.execute.AsynchronousRequest;
import ch.e2e.builder.traceviewer.execute.AsynchronousTransaction;
import ch.e2e.builder.traceviewer.execute.Logging;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.Identifier;
import ch.e2e.builder.traceviewer.tree.menu.RefreshIdentifiersEvent;
import ch.e2e.event.EventController;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetIdentifiersTransaction
extends AsynchronousTransaction {
    private static final String XPATH_IDENTIFIERS = "Trace/Identifiers/*";
    private static XPathExpression identifiersExpression;

    public GetIdentifiersTransaction(E2EBuilderModule traceViewer) {
        super(traceViewer);
    }

    public void setTransactionResult(Object result) {
        super.setTransactionResult(result);
        AsynchronousRequest request = (AsynchronousRequest)result;
        AbstractAsyncTestcaseFolder testcaseFolder = (AbstractAsyncTestcaseFolder)request.getSource();
        Document response = request.getResponse();
        if (response != null) {
            List<Identifier> identifiers = this.getIdentifiers(testcaseFolder, response);
            testcaseFolder.setIdentifiers(identifiers);
            EventController.fire((EventObject)((Object)new RefreshIdentifiersEvent((Object)this, testcaseFolder)));
        }
    }

    private List<Identifier> getIdentifiers(AbstractAsyncTestcaseFolder testcaseFolder, Document document) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        try {
            NodeList identifierNodes = (NodeList)identifiersExpression.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < identifierNodes.getLength(); ++i) {
                identifiers.add(new Identifier(testcaseFolder, (Object)identifierNodes.item(i)));
            }
        }
        catch (XPathExpressionException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
        }
        return identifiers;
    }

    static {
        try {
            XPathEvaluator xpath = new XPathEvaluator();
            identifiersExpression = xpath.compile(XPATH_IDENTIFIERS);
        }
        catch (XPathException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(GetIdentifiersTransaction.class.getName(), "", e);
        }
    }
}

