/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer;

import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.module.ModuleInfo;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.importer.WSDLImportTarget;
import ch.e2e.builder.trace.tree.DeleteWsdlEvent;
import ch.e2e.builder.trace.tree.RenameWsdlEvent;
import ch.e2e.builder.traceviewer.Logging;
import ch.e2e.builder.traceviewer.ShowErrorEvent;
import ch.e2e.builder.traceviewer.ShowInfoEvent;
import ch.e2e.builder.traceviewer.ShowStatusEvent;
import ch.e2e.builder.traceviewer.importer.ImportWsdlEvent;
import ch.e2e.builder.traceviewer.importer.WSDLImporter;
import ch.e2e.builder.traceviewer.swing.MainPanel;
import ch.e2e.builder.traceviewer.swing.tree.AsynchronousTreeView;
import ch.e2e.builder.traceviewer.swing.tree.SynchronousTreeView;
import ch.e2e.builder.traceviewer.swing.tree.TreeView;
import ch.e2e.builder.traceviewer.swing.tree.TreeViewPane;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousFolderEvent;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousFolderExecuter;
import ch.e2e.builder.traceviewer.tree.menu.DeleteWsdlExecuter;
import ch.e2e.builder.traceviewer.tree.menu.RenameWsdlExecuter;
import ch.e2e.builder.traceviewer.xsltinterface.XSLTOutput;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JComponent;

public class TraceViewer
extends E2ETraceModule
implements WSDLImportTarget,
Logging {
    public static String TITLE_MESSAGES;
    public static final String MODULE_NAME = "tracer";
    public static final String KEY_MAX_NESTING_LEVEL = "wsdl.import.max.nesting.level";
    public static final int MAX_NESTING_LEVEL_DEFAULT = 8;
    private static final String MENU_IMPORT_MENU = "tracer.menu.import";
    private static final String MENU_IMPORT_WSDL = "tracer.menu.import.wsdl";
    private E2EBuilderProject project = null;
    private TreeViewPane tree = null;
    private MainPanel main = null;
    private SynchronousTestcaseRoot synchronousRoot;
    private AsynchronousTestcaseRoot asynchronousRoot;
    private static final HashMap<Class<? extends TreeView>, String[][]> enabledMenuEntriesMap;
    private static final HashMap<Class<? extends TreeView>, String[][]> disabledMenuEntriesMap;

    public TraceViewer(ModuleInfo moduleInfo, Properties properties, String modulePackagePrefix) {
        super(moduleInfo, properties, modulePackagePrefix);
        System.setProperty("ch.e2e.builder.trace.xml.editor", "ch.e2e.builder.traceviewer.swing.testcase.XmlCodeEditor");
        TITLE_MESSAGES = this.getTranslation("tracer.message.view");
        XSLTOutput.setModule((String)MODULE_NAME, (String)TITLE_MESSAGES);
        String importedTestcases = this.getTranslation("tree.imported.testcases.folder");
        this.synchronousRoot = new SynchronousTestcaseRoot(importedTestcases);
        this.asynchronousRoot = new AsynchronousTestcaseRoot(importedTestcases);
        this.createMenuEntries();
        this.addEventHandler();
    }

    public String getDefaultMessageViewTitle() {
        return TITLE_MESSAGES;
    }

    public SynchronousTestcaseRoot getSynchronousRoot() {
        return this.synchronousRoot;
    }

    public AsynchronousTestcaseRoot getAsynchronousRoot() {
        return this.asynchronousRoot;
    }

    private void createMenuEntries() {
        this.addMenuItem(new String[]{MENU_IMPORT_MENU, MENU_IMPORT_WSDL}, null, new ImportWsdlEvent(), -1, WSDLImporter.newInstance(this));
    }

    public boolean prepare() {
        this.setPrintEnabled(false);
        return true;
    }

    public synchronized JComponent getOverviewWindow() {
        this.initialize();
        return this.tree;
    }

    public synchronized JComponent getMainWindow() {
        this.initialize();
        return this.main;
    }

    public Object getPrintableObject() {
        return this.main.getPrintableObject();
    }

    private void initialize() {
        if (this.main == null) {
            this.main = new MainPanel(this);
        }
        if (this.tree == null) {
            this.tree = new TreeViewPane(this.main, this.synchronousRoot, this.asynchronousRoot, this);
        }
    }

    public void projectOpened(ProjectEvent event) {
        this.project = event.getProject();
        boolean enabled = this.project.getProjectHome() != null;
        this.setMenuEnabled(MENU_IMPORT_MENU, enabled);
        for (String[][] entries : enabledMenuEntriesMap.values()) {
            for (String[] entry : entries) {
                this.setMenuItemEnabled(entry, enabled);
            }
        }
        this.setMenuItemEnabled(new String[]{"menu.project", "menu.project.preferences"}, enabled);
        this.clearMessageView(TITLE_MESSAGES);
        this.checkNestingLevelEntry();
        this.refresh();
    }

    public void refresh() {
        if (this.tree != null) {
            try {
                this.tree.refresh(true);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = this.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                    this.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                }
            }
            catch (WrongIDFileVersionException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableMenuEntries(Class<? extends TreeView> clazz) {
        String[][] namesArray = enabledMenuEntriesMap.get(clazz);
        if (namesArray != null) {
            for (String[] names : namesArray) {
                this.setMenuItemEnabled(names, true);
            }
        }
    }

    public void disableMenuEntries(Class<? extends TreeView> clazz) {
        String[][] namesArray = disabledMenuEntriesMap.get(clazz);
        if (namesArray != null) {
            for (String[] names : namesArray) {
                this.setMenuItemEnabled(names, false);
            }
        }
    }

    public void applicationClosing() {
        this.synchronousRoot.saveTestcases();
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TraceViewer.this.showStatusMessage(((ShowStatusEvent)event).getMessage());
            }
        }, ShowStatusEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TraceViewer.this.showError(((ShowErrorEvent)event).getMessage());
            }
        }, ShowErrorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TraceViewer.this.showInfo(((ShowInfoEvent)event).getMessage());
            }
        }, ShowInfoEvent.class);
        EventController.register((EventExecuter)new RenameWsdlExecuter(this), RenameWsdlEvent.class);
        EventController.register((EventExecuter)new DeleteWsdlExecuter(this), DeleteWsdlEvent.class);
        EventController.register((EventExecuter)new DeleteAsynchronousFolderExecuter(this), DeleteAsynchronousFolderEvent.class);
    }

    private void checkNestingLevelEntry() {
        if (this.hasProjectProperty(KEY_MAX_NESTING_LEVEL)) {
            int genericNestingLevel = this.getGenericProjectProperty(KEY_MAX_NESTING_LEVEL, 8);
            int moduleNestingLevel = this.getProjectProperty(KEY_MAX_NESTING_LEVEL, -1);
            this.removeProjectProperty(KEY_MAX_NESTING_LEVEL);
            int nestingLevel = Math.max(genericNestingLevel, moduleNestingLevel);
            if (nestingLevel != -1 && nestingLevel != 8) {
                try {
                    this.setGenericProjectProperty(KEY_MAX_NESTING_LEVEL, nestingLevel);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.getProjectPool().saveProject();
            }
        }
    }

    static {
        enabledMenuEntriesMap = new HashMap();
        disabledMenuEntriesMap = new HashMap();
        enabledMenuEntriesMap.put(SynchronousTreeView.class, new String[][]{{MENU_IMPORT_MENU, MENU_IMPORT_WSDL}});
        enabledMenuEntriesMap.put(AsynchronousTreeView.class, new String[][]{{MENU_IMPORT_MENU, MENU_IMPORT_WSDL}});
    }
}

