/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.Output;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.util.StringTools;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ScriptOutput
extends Output {
    public ScriptOutput(UmlObject parent, Element element) {
        super(parent, element);
    }

    public ScriptOutput(UmlObject parent, Element element, TraceContainer traceContainer) {
        super(parent, element, traceContainer);
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String type = child.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        this.addIOEntry(child, traceContainer);
    }

    private void addIOEntry(Element child, TraceContainer traceContainer) {
        String value;
        String name = child.getNodeName();
        if (name.startsWith("value") && child.getChildNodes().getLength() == 1 && child.getFirstChild() instanceof Text) {
            value = ((Text)child.getFirstChild()).getData();
            value = StringTools.replaceChars((String)value, (String)"\r\n", (String[])new String[]{"\\r", "\\n"});
            child.removeChild(child.getFirstChild());
            child.appendChild(child.getOwnerDocument().createTextNode(value));
        }
        String type = TypeMapper.mapTypes(child, traceContainer.getNamespaceContext());
        value = traceContainer.addIOEntry(child, "SCRIPTIO_OUTPUT");
        Data data = new Data(name, value, type);
        data.setObjectId(child);
        this.addChild(data);
    }
}

