/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.uml.UmlObject;

public class Data
extends UmlObject {
    private final String value;
    private final String datatype;
    private final int type;
    private final boolean transformed;

    public Data(String name, String value, String datatype) {
        this(name, value, datatype, false);
    }

    public Data(String name, String value, String datatype, boolean transformed) {
        super(name);
        this.value = value;
        this.datatype = datatype;
        this.type = this.mapType(datatype);
        this.transformed = transformed;
    }

    public String getValue() {
        return this.value;
    }

    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public int internalGetType() {
        return this.type;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    private int mapType(String datatype) {
        switch (datatype) {
            case "SOAP-ENC:Array": {
                return 10004;
            }
            case "Base Types.String": {
                return 10019;
            }
            case "Base Types.Blob": {
                return 10005;
            }
            case "Base Types.Boolean": {
                return 10006;
            }
            case "Base Types.DateTime": {
                return 10010;
            }
            case "Base Types.Float": {
                return 10011;
            }
            case "Base Types.Integer": {
                return 10014;
            }
        }
        return 10009;
    }

    @Override
    public String getStereotype() {
        return null;
    }

    @Override
    public String getUmlLabel() {
        return this.getName() + " : " + this.datatype;
    }
}

