/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.response;

import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.response.SynchronousTraceContainer;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.IOContainer;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.dom.BridgeNamespaceContext;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractResponseParser {
    protected final Matcher VERSION_FINDER = Pattern.compile("\\d+(:?[_.]\\d+)*").matcher("");
    protected UmlTree umlTree;
    protected TraceContainer traceContainer;
    protected boolean responseHasErrors;
    protected long lastRunDate;
    protected String serverVersion;

    public void parse(SOAPResponse response, AbstractSynchronousTestcase testcase) throws IOException, TransformerException {
        this.traceContainer = new SynchronousTraceContainer(testcase);
        Document responseDocument = response.getResponseDocument();
        Document requestDocument = DomUtilities.newDocument((String)"Request");
        try {
            if (testcase.isRPCEncoding()) {
                testcase.getRequest().fillRequestRoot(requestDocument.getDocumentElement(), testcase, this.traceContainer);
            } else {
                testcase.getRequest().fillDocumentEncodedRequestRoot(requestDocument.getDocumentElement(), testcase);
                DomUtilities.serialize((File)testcase.getDocumentEncodedResponseFile(), (Document)responseDocument, (boolean)true);
            }
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        this.traceContainer.addNamespaces(responseDocument.getDocumentElement());
        this.replaceResponseIO(responseDocument, this.traceContainer);
        DomUtilities.serialize((File)new File(testcase.getTraceFolder(), "request"), (Document)requestDocument, (boolean)true);
        this.responseHasErrors = this.containsErrors(responseDocument);
        DomUtilities.serialize((File)testcase.getResponseFile(), (Document)responseDocument, (boolean)true);
        this.umlTree = this.createUmlTree(response.getTraceDocument(), testcase);
        Instant now = Instant.now();
        this.lastRunDate = now.toEpochMilli();
        this.traceContainer.close(responseDocument);
        this.createSystemDocument(testcase, now, this.serverVersion, this.umlTree);
    }

    public void parse(Document response, AbstractAsynchronousTestcase testcase, TraceContainer traceContainer) throws IOException, TransformerException {
        this.traceContainer = traceContainer;
        this.umlTree = this.createUmlTree(response, testcase);
        DomUtilities.serialize((File)testcase.getResponseFile(), (Document)response, (boolean)true);
        Instant now = Instant.now();
        this.lastRunDate = now.toEpochMilli();
        traceContainer.close(response);
        Document systemDocument = this.createSystemDocument(testcase, now, this.serverVersion, this.umlTree);
        DomUtilities.serialize((File)new File(testcase.getTraceFolder(), "system.info"), (Document)systemDocument, (boolean)false);
    }

    public boolean responseHasErrors() {
        return this.responseHasErrors;
    }

    public long getLastRunDate() {
        return this.lastRunDate;
    }

    public TraceContainer getTraceContainer() {
        return this.traceContainer;
    }

    public UmlTree getUmlTree() {
        return this.umlTree;
    }

    protected UmlTree createUmlTree(Document traceDocument, AbstractSynchronousTestcase testcase) {
        return null;
    }

    protected UmlTree createUmlTree(Document traceDocument, AbstractAsynchronousTestcase testcase) {
        return null;
    }

    protected void createSystemDocument(AbstractSynchronousTestcase testcase, Instant runtime, String serverVersion, UmlTree umlTree) throws TransformerException, IOException {
        String traceLevelStr;
        Document result = DomUtilities.newDocument((String)"System");
        Element root = result.getDocumentElement();
        Element soapAction = result.createElement("soapAction");
        soapAction.appendChild(result.createTextNode(testcase.getSoapAction()));
        root.appendChild(soapAction);
        Element documentStyle = result.createElement("documentStyle");
        documentStyle.appendChild(result.createTextNode(testcase.isRPCEncoding() ? "rpc" : "document"));
        root.appendChild(documentStyle);
        serverVersion = serverVersion != null && this.VERSION_FINDER.reset(serverVersion).matches() ? this.VERSION_FINDER.group().replace('_', '.') : "unkown";
        Element version = result.createElement("version");
        version.appendChild(result.createTextNode(serverVersion));
        root.appendChild(version);
        Element lastRun = result.createElement("lastRun");
        Element date = result.createElement("date");
        date.appendChild(result.createTextNode(runtime.toString()));
        lastRun.appendChild(date);
        Element location = result.createElement("location");
        location.appendChild(result.createTextNode(testcase.getLocation()));
        lastRun.appendChild(location);
        Element trace = result.createElement("Trace");
        Element traceLevel = result.createElement("tracelevel");
        if (testcase.getTraceSettings().isEnabled()) {
            if (umlTree != null) {
                String string = traceLevelStr = testcase.getTraceSettings().getTraceLevel() == TraceSettings.TraceLevel.Full ? TraceSettings.TraceLevel.Full.toString() : TraceSettings.TraceLevel.Moderate.toString();
                if (umlTree.hasTraceError()) {
                    Element traceError = result.createElement("TraceError");
                    traceError.appendChild(result.createTextNode(umlTree.getTraceError().getMessage()));
                    trace.appendChild(traceError);
                }
            } else {
                traceLevelStr = "Compiled without trace";
            }
        } else {
            traceLevelStr = "None";
        }
        traceLevel.appendChild(result.createTextNode(traceLevelStr));
        trace.appendChild(traceLevel);
        lastRun.appendChild(trace);
        root.appendChild(lastRun);
        DomUtilities.serialize((File)new File(testcase.getTraceFolder(), "system.info"), (Document)result, (boolean)false);
    }

    protected Document createSystemDocument(AbstractAsynchronousTestcase testcase, Instant runtime, String serverVersion, UmlTree umlTree) {
        return null;
    }

    protected boolean containsErrors(Document responseDocument) {
        BridgeNamespaceContext namespaceContext = this.traceContainer.getNamespaceContext();
        String uri = namespaceContext.getNamespaceURI(namespaceContext.getSoapEnvelopePrefix());
        NodeList faults = responseDocument.getElementsByTagNameNS(uri, "Fault");
        return faults != null && faults.getLength() > 0;
    }

    protected UmlTree createUmlTree(Node traceNode, TraceSettings traceSettings) {
        UmlTree umlTree = UmlObjectFactory.createUmlTree((Element)traceNode, this.traceContainer);
        traceSettings.checkInspection(umlTree);
        return umlTree;
    }

    protected void replaceResponseIO(Document responseDocument, TraceContainer traceContainer) {
        BridgeNamespaceContext namespaceContext = traceContainer.getNamespaceContext();
        String uri = namespaceContext.getNamespaceURI(namespaceContext.getSoapEnvelopePrefix());
        NodeList responses = responseDocument.getElementsByTagNameNS(uri, "Body");
        if (responses != null && responses.getLength() == 1) {
            Element body = (Element)responses.item(0);
            NodeList childNodes = body.getChildNodes();
            Node responseElement = null;
            int length = childNodes.getLength();
            for (int i = 0; i < length && responseElement == null; ++i) {
                Node child = childNodes.item(i);
                if (!(child instanceof Element)) continue;
                responseElement = (Element)child;
            }
            if (responseElement != null) {
                IOContainer ioContainer = traceContainer.getIOContainer();
                NodeList children = responseElement.getChildNodes();
                length = children.getLength();
                for (int i = 0; i < length; ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element)) continue;
                    TypeMapper.mapTypes((Element)child, namespaceContext);
                    ioContainer.addIOEntry((Element)child, "RESPONSE");
                }
            }
        }
    }
}

