/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.tools.TypeMapper;
import ch.e2e.io.FileUtilities;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SimpleTypeParameter
extends Parameter {
    public SimpleTypeParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder);
        boolean isNil = Boolean.valueOf(namespaceAware ? parameterElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil") : parameterElement.getAttribute("nil"));
        if (isNil) {
            this.setDisplayValue(null);
        } else {
            this.setValue(this.createValue(parameterElement));
            this.changed = false;
        }
    }

    public SimpleTypeParameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.setDisplayValue(null);
    }

    @Override
    public boolean importData(Transferable t) {
        boolean imported = false;
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (files != null && files.size() == 1) {
                    StringWriter out = new StringWriter();
                    FileUtilities.copy((Reader)new FileReader((File)files.get(0)), (Writer)out);
                    imported = this.importValue(out.toString());
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                imported = this.importValue(t.getTransferData(DataFlavor.stringFlavor));
            }
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException e) {
            System.out.println("importData: I/O exception");
        }
        return imported;
    }

    @Override
    public Transferable createTransferable() {
        return this.isNull() ? null : new StringSelection(this.getValue().toString());
    }

    @Override
    public boolean isNull() {
        return this.getValue() == null;
    }

    @Override
    public Element createEmptyParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        parameter.setAttribute("type", this.getTypeName());
        parameter.setAttribute("nil", "true");
        return parameter;
    }

    @Override
    public Element createSOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", TypeMapper.bridgeType2XSD(this.getTypeName()));
        parameter.appendChild(this.toSOAP(document));
        return parameter;
    }

    @Override
    public Element createEmptySOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", TypeMapper.bridgeType2XSD(this.getTypeName()));
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        return parameter;
    }

    protected Node toSOAP(Document document) {
        return document.createTextNode(this.getValue().toString());
    }

    abstract Object createValue(Element var1);

    @Override
    public Element createParameterElement(Document document) {
        String name = this.getName();
        if (this.isArrayItem() && name.startsWith("item")) {
            name = "item";
        }
        Element parameter = document.createElement(name);
        parameter.setAttribute("type", this.getTypeName());
        if (this.isNull()) {
            parameter.setAttribute("nil", "true");
        } else {
            parameter.appendChild(this.toXML(document));
        }
        return parameter;
    }
}

