/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.TestcaseTemplate;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Parameter
implements TestcaseParameter {
    private boolean arrayItem;
    private int type;
    private RecordParameter parent;
    private ParameterDefinitionHolder definitionHolder;
    private String name;
    private String displayValue;
    private Object value;
    boolean changed = false;
    private TestcaseTemplate.SoapVersion soapVersion;

    protected Parameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement.getNodeName(), type, arrayItem, parent, definitionHolder);
    }

    Parameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this.name = name;
        this.arrayItem = arrayItem;
        this.type = type;
        this.parent = parent;
        this.definitionHolder = definitionHolder;
        this.soapVersion = definitionHolder.getNamespacesManager().getSoapVersion();
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }

    @Override
    public String getValueAsString() {
        Object v = this.getValue();
        return v == null ? "NULL" : v.toString();
    }

    @Override
    public boolean isEllipsis() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return !this.isComplex() && !this.isArray() && !this.isEllipsis();
    }

    @Override
    public boolean isComplex() {
        return this.getType() == 10009;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isArrayItem() {
        return this.arrayItem;
    }

    @Override
    public boolean isBlob() {
        return this.getType() == 10005;
    }

    @Override
    public boolean isDateTime() {
        return this.getType() == 10010;
    }

    @Override
    public boolean isTruncated() {
        return false;
    }

    @Override
    public boolean hasItems() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Object getChild(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public boolean isLeaf() {
        return true;
    }

    public RecordParameter getParent() {
        return this.parent;
    }

    String[] getPath() {
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(this.name);
        for (RecordParameter parent = this.parent; parent != null; parent = parent.getParent()) {
            pathList.add(parent.getName());
        }
        Collections.reverse(pathList);
        return pathList.toArray(new String[0]);
    }

    ParameterDefinitionHolder getDefinitionHolder() {
        return this.definitionHolder;
    }

    @Override
    public void setValue(Object value) {
        this.changed = false;
        if (this.value == null && value != null || this.value != null && !this.value.equals(value)) {
            this.setDisplayValue(value);
            this.value = value;
            this.changed = true;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean importData(Transferable t) {
        return false;
    }

    @Override
    public Transferable createTransferable() {
        return null;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public abstract Element createSOAPParameter(Document var1);

    public abstract Element createEmptySOAPParameter(Document var1);

    public abstract Element createParameterElement(Document var1);

    public abstract Parameter createEmptyParameter(RecordParameter var1);

    public abstract Parameter copy(RecordParameter var1);

    void setDisplayValue(Object value) {
        if (value == null) {
            this.displayValue = "<html><span style='color:#808080'>NULL</span></html>";
        } else {
            String displayValue = this.getValueAsString(value);
            this.displayValue = '\"' + displayValue + '\"';
        }
    }

    public void setDisplayValueUnquoted(Object value) {
        this.displayValue = value == null ? "<html><span style='color:#808080'>NULL</span></html>" : this.getValueAsString(value);
    }

    protected String getValueAsString(Object value) {
        return value.toString();
    }

    public String toString() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    protected Node toXML(Document document) {
        return document.createTextNode(this.getValue().toString());
    }

    public boolean differsFrom(Parameter other) {
        return !this.name.equals(other.name) || this.type != other.type || this.arrayItem != other.arrayItem || this.value != other.value && (this.value == null || !this.value.equals(other.value));
    }

    public TestcaseTemplate.SoapVersion getSoapVersion() {
        return this.soapVersion;
    }
}

