/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.NativeTypeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import java.math.BigInteger;
import org.w3c.dom.Element;

public class BigIntegerParameter
extends NativeTypeParameter {
    public BigIntegerParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public BigIntegerParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private BigIntegerParameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.setValue(BigInteger.ZERO);
    }

    @Override
    public BigIntegerParameter copy(RecordParameter parent) {
        BigIntegerParameter result = new BigIntegerParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.Integer";
    }

    @Override
    public boolean importValue(Object value) {
        boolean imported = false;
        if (value == null) {
            this.setValue(value);
            imported = true;
        } else {
            try {
                this.setValue(new BigInteger(value.toString()));
                imported = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    Object createValue(Element parameterElement) {
        BigInteger result;
        if (parameterElement.hasChildNodes()) {
            try {
                result = new BigInteger(parameterElement.getFirstChild().getNodeValue());
            }
            catch (NumberFormatException e) {
                result = BigInteger.ZERO;
            }
        } else {
            result = BigInteger.ZERO;
        }
        return result;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new BigIntegerParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
    }
}

