/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.NativeTypeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import java.math.BigDecimal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BigDecimalParameter
extends NativeTypeParameter {
    public BigDecimalParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public BigDecimalParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
    }

    private BigDecimalParameter(String name, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.setValue(BigDecimal.ZERO);
    }

    @Override
    public BigDecimalParameter copy(RecordParameter parent) {
        BigDecimalParameter result = new BigDecimalParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        return result;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Base Types.Float";
    }

    @Override
    public String getValueAsString() {
        String result;
        BigDecimal v = (BigDecimal)this.getValue();
        if (v == null) {
            result = "NULL";
        } else {
            result = v.toPlainString();
            if (result.length() > 80) {
                result = v.toString();
            }
        }
        return result;
    }

    @Override
    protected String getValueAsString(Object value) {
        BigDecimal v = (BigDecimal)value;
        String result = v.toPlainString();
        if (result.length() > 80) {
            result = v.toString();
        }
        return result;
    }

    @Override
    public String toString() {
        BigDecimal v = (BigDecimal)this.getValue();
        return v == null ? "" : v.toPlainString();
    }

    @Override
    protected Node toXML(Document document) {
        return document.createTextNode(this.toString());
    }

    @Override
    public boolean importValue(Object value) {
        boolean imported = false;
        if (value == null) {
            this.setValue(value);
            imported = true;
        } else {
            try {
                this.setValue(new BigDecimal(value.toString()));
                imported = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    Object createValue(Element parameterElement) {
        BigDecimal result;
        if (parameterElement.hasChildNodes()) {
            try {
                result = new BigDecimal(parameterElement.getFirstChild().getNodeValue());
            }
            catch (NumberFormatException e) {
                result = BigDecimal.ZERO;
            }
        } else {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new BigDecimalParameter(this.getName(), this.getType(), this.isArrayItem(), parent, this.getDefinitionHolder());
    }
}

