/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.TestcaseDefaults;
import ch.e2e.builder.trace.testcase.uml.InspectionEvent;
import ch.e2e.builder.trace.testcase.uml.InspectionListener;
import ch.e2e.builder.trace.testcase.uml.InspectionObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.resource.Properties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TraceSettings
implements InspectionListener {
    private Properties properties;
    private boolean enabled;
    private TraceLevel traceLevel;
    private TraceLevel lastRunTraceLevel;
    private boolean useInspectionList;
    private boolean ignoreAllNotInspected;
    private int maxSize;
    private Collection<String> inspectionIds;
    private Collection<String> lastRunInspectionIds;

    public TraceSettings(Properties properties) {
        this.properties = properties;
        this.inspectionIds = new ArrayList<String>();
        this.lastRunInspectionIds = new ArrayList<String>();
        this.readSettings();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public void setTraceLevel(TraceLevel traceLevel) {
        this.traceLevel = traceLevel;
    }

    public boolean isUseInspectionList() {
        return this.useInspectionList;
    }

    public void setUseInspectionList(boolean useInspectionList) {
        this.useInspectionList = useInspectionList;
    }

    public boolean isIgnoreAllNotInspected() {
        return this.ignoreAllNotInspected;
    }

    public void setIgnoreAllNotInspected(boolean ignoreAllNotInspected) {
        this.ignoreAllNotInspected = ignoreAllNotInspected;
    }

    public boolean containsInspectedElement(String id) {
        return this.lastRunInspectionIds.contains(id);
    }

    public Collection<String> getInspectionIds() {
        return this.inspectionIds;
    }

    public boolean setInspectedIds(Collection<String> inspectedIds) {
        boolean changed;
        boolean bl = changed = !this.inspectionIds.equals(inspectedIds);
        if (changed) {
            this.inspectionIds = new ArrayList<String>(inspectedIds);
        }
        return changed;
    }

    public void checkInspection(UmlTree umlTree) {
        this.checkInspection(umlTree, this.inspectionIds);
    }

    private void checkInspection(UmlObject parent, Collection<String> inspectedIds) {
        int length = parent.getChildCount();
        for (int i = 0; i < length; ++i) {
            UmlObject child = (UmlObject)parent.getChild(i);
            if (child instanceof InspectionObject) {
                boolean inspected = inspectedIds.contains(child.getOriginalName());
                InspectionObject inspectionObject = (InspectionObject)((Object)child);
                inspectionObject.setInspected(inspected);
                inspectionObject.addInspectionListener(this);
            }
            this.checkInspection(child, inspectedIds);
        }
    }

    @Override
    public void inspectionStateChanged(InspectionEvent event) {
        boolean save = false;
        String id = ((InspectionObject)event.getSource()).getId();
        if (event.getState()) {
            if (!this.inspectionIds.contains(id)) {
                save = this.inspectionIds.add(id);
            }
        } else {
            save = this.inspectionIds.remove(id);
        }
        if (save) {
            try {
                this.properties.write(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setLastRunInfos() {
        this.lastRunTraceLevel = this.traceLevel;
        this.lastRunInspectionIds.clear();
        if (this.useInspectionList) {
            this.lastRunInspectionIds.addAll(this.inspectionIds);
        }
    }

    public Element createTraceElement(Document owner) {
        Element trace = owner.createElementNS("http://e2e.ch/bridge", "bridge:Trace");
        if (this.enabled) {
            trace.setAttribute("level", this.traceLevel == TraceLevel.Full ? TraceLevel.Full.toString() : (this.traceLevel == TraceLevel.None ? TraceLevel.None.toString() : TraceLevel.Moderate.toString()));
        } else {
            trace.setAttribute("level", TraceLevel.None.toString());
        }
        trace.setAttribute("maxSize", String.valueOf(this.maxSize));
        if (this.useInspectionList) {
            Element inspectionList = owner.createElementNS("http://e2e.ch/bridge", "bridge:InspectionList");
            for (String id : this.inspectionIds) {
                Element inspectedActivity = owner.createElementNS("http://e2e.ch/bridge", "bridge:Activity");
                inspectedActivity.appendChild(owner.createTextNode(id));
                inspectionList.appendChild(inspectedActivity);
            }
            inspectionList.setAttribute("ignoreAll", String.valueOf(this.ignoreAllNotInspected));
            trace.appendChild(inspectionList);
        }
        return trace;
    }

    public void write() {
        this.properties.setProperty("trace.enabled", this.enabled);
        this.properties.setProperty("trace.mode", (long)this.traceLevel.getMode());
        this.properties.setProperty("last.run.trace.mode", (long)this.lastRunTraceLevel.getMode());
        this.properties.setProperty("use.inspection.list", this.useInspectionList);
        this.properties.setProperty("inspection", this.inspectionIds.toArray(new String[this.inspectionIds.size()]));
        this.properties.setProperty("last.run.inspection", this.lastRunInspectionIds.toArray(new String[this.lastRunInspectionIds.size()]));
        this.properties.setProperty("property.trace.ignore.all.not.inspected", this.ignoreAllNotInspected);
        this.properties.setProperty("trace.maxsize", (long)this.maxSize);
    }

    private void readSettings() {
        boolean newTraceSettings = true;
        try {
            String traceLevel = this.properties.getString("trace.level");
            this.properties.removeProperty("trace.level");
            try {
                this.traceLevel = TraceLevel.valueOf(traceLevel);
                if (this.traceLevel == TraceLevel.None) {
                    this.enabled = false;
                    this.traceLevel = TraceLevel.Moderate;
                } else {
                    this.enabled = true;
                }
            }
            catch (IllegalArgumentException e) {
                this.enabled = true;
                this.traceLevel = TraceLevel.Moderate;
            }
            newTraceSettings = false;
        }
        catch (MissingResourceException traceLevel) {
            // empty catch block
        }
        if (newTraceSettings) {
            this.enabled = this.properties.getBoolean("trace.enabled", true);
            try {
                this.traceLevel = TraceLevel.valueOf((int)this.properties.getInteger("trace.mode", TestcaseDefaults.getInstance().getInteger("testcase.trace.mode.default")));
                if (this.enabled && this.traceLevel.equals(TraceLevel.None)) {
                    this.traceLevel = TraceLevel.getDefaultLevel();
                    this.properties.setProperty("trace.mode", (long)this.traceLevel.getMode());
                }
            }
            catch (Exception e) {
                this.traceLevel = TraceLevel.getDefaultLevel();
                this.properties.setProperty("trace.mode", (long)this.traceLevel.getMode());
            }
            try {
                this.lastRunTraceLevel = TraceLevel.valueOf((int)this.properties.getInteger("trace.mode"));
            }
            catch (Exception e) {
                this.lastRunTraceLevel = null;
            }
        }
        this.ignoreAllNotInspected = this.properties.getBoolean("property.trace.ignore.all.not.inspected", false);
        boolean defaultUseInspectionList = TestcaseDefaults.getInstance().getBoolean("testcase.trace.mode.default");
        this.useInspectionList = this.properties.getBoolean("use.inspection.list", defaultUseInspectionList);
        this.inspectionIds.clear();
        try {
            this.inspectionIds.addAll(Arrays.asList(this.properties.getStringArray("inspection")));
        }
        catch (MissingResourceException e) {
            this.properties.setProperty("inspection", new String[0]);
        }
        this.lastRunInspectionIds.clear();
        try {
            this.lastRunInspectionIds.addAll(Arrays.asList(this.properties.getStringArray("last.run.inspection")));
        }
        catch (MissingResourceException e) {
            this.properties.setProperty("last.run.inspection", new String[0]);
        }
        try {
            this.maxSize = (int)this.properties.getInteger("trace.maxsize", TestcaseDefaults.getInstance().getInteger("testcase.trace.max.size.default"));
        }
        catch (Exception e) {
            this.maxSize = 10;
            this.properties.setProperty("trace.maxsize", (long)this.maxSize);
        }
    }

    public static enum TraceLevel implements Cloneable
    {
        None(-1),
        Moderate(0),
        Full(1);

        private final int mode;
        private static final HashMap<Integer, TraceLevel> map;

        public static TraceLevel valueOf(int mode) {
            TraceLevel level = map.get(mode);
            return level == null ? TraceLevel.getDefaultLevel() : level;
        }

        public int getMode() {
            return this.mode;
        }

        public static TraceLevel getDefaultLevel() {
            TraceLevel defaultLevel = Moderate;
            try {
                defaultLevel = TraceLevel.valueOf((int)TestcaseDefaults.getInstance().getInteger("testcase.trace.mode.default"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return defaultLevel;
        }

        private TraceLevel(int mode) {
            this.mode = mode;
        }

        static {
            map = new HashMap();
            for (TraceLevel l : TraceLevel.values()) {
                map.put(l.mode, l);
            }
        }
    }
}

