/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.Logging;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class LogFile
extends TestcaseObject
implements Logging {
    private File logFile;
    private String internalName;
    private String filename;

    public LogFile(TestcaseContainer parent, File logFolder, String filename, String internalName) {
        this.setParent(parent);
        this.logFile = new File(logFolder, filename);
        this.filename = filename;
        this.internalName = internalName;
    }

    public LogFile(Testcase parent, String filename, String internalName) {
        this(parent, parent.getTraceFolder(), filename, internalName);
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void renameTo(File newTraceFolder) {
        this.logFile = new File(newTraceFolder, this.filename);
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.logFile.getParentFile().exists()) {
            this.logFile.getParentFile().mkdirs();
        }
        return new PrintWriter(this.logFile, "utf-8");
    }

    @Override
    public String getName() {
        return this.logFile.getName();
    }

    public boolean exists() {
        return this.logFile.exists();
    }

    @Override
    protected void delete() {
        this.logFile.delete();
    }

    @Override
    public int getType() {
        return 9;
    }

    public String getData() {
        StringWriter out = new StringWriter();
        if (this.logFile.exists()) {
            try {
                FileUtilities.copy((Reader)new FileReader(this.logFile), (Writer)out);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "getData", e);
            }
        }
        return out.toString();
    }

    @Override
    protected void clear() {
    }

    @Override
    public Object getChild(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndexOfChild(Object child) {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String toString() {
        return this.internalName;
    }

    @Override
    public int hashCode() {
        return this.logFile.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = obj != null && obj instanceof File ? this.logFile.equals(obj) : (obj instanceof LogFile ? this.logFile.equals(((LogFile)obj).logFile) : super.equals(obj));
        return result;
    }
}

