/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.request.AbstractRequest;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.trace.request.RequestExecuter;
import ch.e2e.event.EventController;
import ch.e2e.util.StringTools;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.EventObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestClient {
    private static RequestClient client;

    protected RequestClient() {
    }

    public static RequestClient getInstance() {
        if (client == null) {
            client = new RequestClient();
        }
        return client;
    }

    public Document performRequest(AbstractRequest request) throws Exception {
        return this.performRequest(request, new RequestExecuter("application/xml", "application/soap+xml", "text/xml"));
    }

    protected Document performRequest(AbstractRequest request, RequestExecuter executer) throws RequestException {
        Document result;
        try {
            result = executer.execute(request.getRequest(), request.getLocation(), request.getCredentials(), 180);
            this.checkStatus(request, result);
        }
        catch (RequestException e) {
            EventController.fire((EventObject)new SendErrorEvent((Object)request, this.createErrorMessage(e, request.getLocation())));
            throw e;
        }
        finally {
            executer.releaseConnection();
        }
        return result;
    }

    private void checkStatus(AbstractRequest request, Document document) {
        String error;
        Node errorNode;
        Node status = document.getElementsByTagName("Status").item(0);
        if (status != null && !status.getTextContent().equals("OK") && (errorNode = document.getElementsByTagName("Error").item(0)) != null && (error = errorNode.getTextContent()) != null) {
            EventController.fire((EventObject)new SendErrorEvent((Object)request, "HttpClient [" + request.getLocation() + "]: " + error));
        }
    }

    private String createErrorMessage(Exception e, String location) {
        String result = e.getCause() instanceof ConnectException ? "http.client.error.connecting" : (e instanceof SocketException ? "http.client.error.connecting" : "http.client.error.exception");
        result = StringTools.replaceProperty((String)result, (String)"url", (String)location);
        String message = e.getMessage() == null ? "" : e.getMessage();
        result = StringTools.replaceProperty((String)result, (String)"exception.message", (String)(e instanceof NullPointerException ? "NullPointerException" : message));
        return result;
    }
}

