/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.execute;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.execute.RequestExecuter;
import ch.e2e.builder.trace.execute.SynchronousTestcaseRequest;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.trace.request.ResponseException;
import ch.e2e.builder.trace.request.SOAPFault;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.event.EventController;
import ch.e2e.util.StringTools;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.EventObject;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HttpClient {
    private HttpClient() {
    }

    public static SOAPResponse performRequest(SynchronousTestcaseRequest request) {
        return HttpClient.performRequest(request, request.getTestcase().getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPResponse performRequest(SynchronousTestcaseRequest request, String location) {
        SOAPResponse result;
        AbstractSynchronousTestcase testcase = request.getTestcase();
        NamespacesManager namespacesManager = null;
        try {
            namespacesManager = testcase.getRequest().getNamespacesManager();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        testcase.getTraceFolder().mkdirs();
        RequestExecuter executer = new RequestExecuter(testcase.getRequestLog(), testcase.getResponseLog());
        try {
            Document requestDocument = testcase.getRequest().createRequestDocument(testcase);
            Document resultDocument = executer.execute(requestDocument, location, testcase.getCredentials(), testcase.getTimeout(), request.getId(), (Properties)testcase.getHttpHeaders(), testcase.getSoapAction());
            result = HttpClient.isValidSoapEnvelopeNamespaceUri(resultDocument.getDocumentElement().getNamespaceURI()) ? new SOAPResponse(resultDocument, namespacesManager) : new SOAPFault("HTTP_06", "No SOAP response", namespacesManager);
        }
        catch (RequestException e) {
            String cause = "";
            if (e.getCause() instanceof ResponseException) {
                result = new SOAPFault(e.getErrorCode(), e.getMessage(), namespacesManager);
            } else {
                if (e.getCause() != null) {
                    cause = e.getCause().getClass().getSimpleName() + ": ";
                }
                result = new SOAPFault(e.getErrorCode(), e.getMessage() + " (" + cause + e.getLocation() + ")", namespacesManager);
            }
            EventController.fire((EventObject)new SendErrorEvent((Object)request, HttpClient.createErrorMessage(e, e.getLocation())));
        }
        catch (Exception e) {
            result = new SOAPFault("HTTP_05", e.getMessage() + " (" + location + ")", namespacesManager);
            EventController.fire((EventObject)new SendErrorEvent((Object)request, HttpClient.createErrorMessage(e, location)));
        }
        finally {
            executer.releaseConnection();
        }
        return result;
    }

    private static String createErrorMessage(Exception e, String location) {
        String result = e instanceof ConnectException ? "http.client.error.connecting" : (e instanceof SocketException ? "http.client.error.connecting" : "http.client.error.exception");
        result = StringTools.replaceProperty((String)result, (String)"url", (String)location);
        String message = e.getMessage() == null ? "" : e.getMessage();
        result = StringTools.replaceProperty((String)result, (String)"exception.message", (String)(e instanceof NullPointerException ? "NullPointerException" : message));
        return result;
    }

    private static boolean isValidSoapEnvelopeNamespaceUri(String uri) {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(uri) || "http://www.w3.org/2003/05/soap-envelope".equals(uri);
    }
}

