/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan b;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    public void paintMargin(Graphics graphics) {
        FoldingSpan[] foldingSpanArray;
        boolean bl = AbstractMargin.a;
        CodeEditor codeEditor = this.getCodeEditor();
        if (!bl) {
            if (codeEditor == null) {
                return;
            }
            codeEditor = this.getCodeEditor();
        }
        int n = codeEditor.getPainter().getLineHeight();
        for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
            this.paintFolding(graphics, foldingSpan, n);
            if (!bl) continue;
        }
    }

    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        CodeFoldingPainter codeFoldingPainter = this._codeFoldingPainter;
        if (!AbstractMargin.a) {
            if (codeFoldingPainter == null) {
                this._codeFoldingPainter = new DefaultCodeFoldingPainter();
            }
            codeFoldingPainter = this._codeFoldingPainter;
        }
        return codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected void paintFolding(Graphics graphics, FoldingSpan foldingSpan, int n) {
        block13: {
            int n2;
            int n3;
            int n4;
            int n5;
            block8: {
                block9: {
                    boolean bl;
                    block12: {
                        int n6;
                        int n7;
                        block10: {
                            block11: {
                                bl = AbstractMargin.a;
                                CodeEditor codeEditor = this.getCodeEditor();
                                if (!bl) {
                                    if (codeEditor == null) {
                                        return;
                                    }
                                    codeEditor = this.getCodeEditor();
                                }
                                n5 = codeEditor.getFirstLine();
                                n4 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                n3 = this.b == foldingSpan ? 2 : 0;
                                n2 = foldingSpan.isExpanded();
                                if (bl) break block8;
                                if (n2 == 0) break block9;
                                int n8 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                n7 = n4;
                                n6 = n8;
                                if (bl) break block10;
                                if (n7 == n6) break block11;
                                n4 = this.getCodeEditor().modelToViewLine(n4) + 1;
                                n8 = this.getCodeEditor().modelToViewLine(n8) + 1;
                                int n9 = this.getCodeFoldingPainter().paintFoldingStart(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                                int n10 = this.getCodeFoldingPainter().paintFoldingEnd(this, graphics, foldingSpan, new Rectangle(0, (n8 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                                this.getCodeFoldingPainter().paintFoldingLine(this, graphics, foldingSpan, new Rectangle(0, n9, this.getWidth(), n10 - n9), n3);
                                if (!bl) break block12;
                            }
                            n7 = this.getCodeEditor().modelToViewLine(n4);
                            n6 = 1;
                        }
                        n4 = n7 + n6;
                        this.getCodeFoldingPainter().paintExpandedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                    }
                    if (!bl) break block13;
                }
                n2 = this.getCodeEditor().modelToViewLine(n4) + 1;
            }
            n4 = n2;
            this.getCodeFoldingPainter().paintCollapsedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block6: {
            HitInfo hitInfo;
            block13: {
                int n;
                block12: {
                    boolean bl;
                    block11: {
                        block7: {
                            block8: {
                                block10: {
                                    block9: {
                                        HitInfo hitInfo2;
                                        block5: {
                                            bl = AbstractMargin.a;
                                            CodeFoldingMargin codeFoldingMargin = this;
                                            if (!bl) {
                                                if (codeFoldingMargin.getCodeEditor() == null) {
                                                    return;
                                                }
                                                codeFoldingMargin = this;
                                            }
                                            hitInfo2 = hitInfo = codeFoldingMargin.getSpanInfo(mouseEvent.getPoint());
                                            if (bl) break block5;
                                            if (hitInfo2 == null) break block6;
                                            hitInfo2 = hitInfo;
                                        }
                                        n = hitInfo2.a.isExpanded();
                                        if (bl) break block7;
                                        if (n == 0) break block8;
                                        n = hitInfo.b;
                                        if (bl) break block9;
                                        if (n == 0) break block10;
                                        n = hitInfo.b;
                                    }
                                    if (bl) break block7;
                                    if (n != 1) break block8;
                                }
                                this.getCodeEditor().getFoldingModel().collapseFoldingSpan(hitInfo.a);
                                if (!bl) break block6;
                            }
                            n = hitInfo.a.isExpanded() ? 1 : 0;
                        }
                        if (bl) break block11;
                        if (n != 0) break block6;
                        n = hitInfo.b;
                    }
                    if (bl) break block12;
                    if (n == 0) break block13;
                    n = hitInfo.b;
                }
                if (n != 1) break block6;
            }
            this.getCodeEditor().getFoldingModel().expandFoldingSpan(hitInfo.a);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        block3: {
            CodeFoldingMargin codeFoldingMargin;
            block2: {
                codeFoldingMargin = this;
                if (AbstractMargin.a) break block2;
                if (codeFoldingMargin.b == null) break block3;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block5: {
            CodeFoldingMargin codeFoldingMargin;
            block6: {
                HitInfo hitInfo;
                boolean bl;
                block2: {
                    HitInfo hitInfo2;
                    block3: {
                        CodeFoldingMargin codeFoldingMargin2;
                        block4: {
                            bl = AbstractMargin.a;
                            hitInfo = hitInfo2 = this.getSpanInfo(mouseEvent.getPoint());
                            if (bl) break block2;
                            if (hitInfo == null) break block3;
                            codeFoldingMargin2 = this;
                            if (bl) break block4;
                            if (codeFoldingMargin2.b == hitInfo2.a) break block3;
                            this.b = hitInfo2.a;
                            codeFoldingMargin2 = this;
                        }
                        codeFoldingMargin2.repaint();
                        if (!bl) break block5;
                    }
                    hitInfo = hitInfo2;
                }
                if (hitInfo != null) break block5;
                codeFoldingMargin = this;
                if (bl) break block6;
                if (codeFoldingMargin.b == null) break block5;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        boolean bl = AbstractMargin.a;
        CodeEditor codeEditor = this.getCodeEditor();
        if (!bl) {
            if (codeEditor == null) {
                return null;
            }
            codeEditor = this.getCodeEditor();
        }
        int n = codeEditor.getFirstLine();
        int n2 = this.getCodeEditor().getPainter().getLineHeight();
        int n3 = point.y;
        int n4 = n3 / n2;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n5 = n + n4;
        for (FoldingSpan foldingSpan : foldingSpanArray) {
            int n6;
            int n7;
            int n8;
            int n9;
            block14: {
                block11: {
                    int n10;
                    block12: {
                        block13: {
                            block9: {
                                block10: {
                                    int n11 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                    int n12 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                    n9 = this.getCodeEditor().modelToViewLine(n11);
                                    n8 = this.getCodeEditor().modelToViewLine(n12);
                                    n10 = n9;
                                    if (bl) break block9;
                                    if (n10 >= 0) break block10;
                                    n9 = n8;
                                    if (!bl) break block11;
                                }
                                n10 = n8;
                            }
                            if (bl) break block12;
                            if (n10 < 0) break block13;
                            n7 = n8;
                            n6 = n9;
                            if (bl) break block14;
                            if (n7 >= n6) break block11;
                        }
                        n10 = n9;
                    }
                    n8 = n10;
                }
                n7 = n5;
                n6 = n9;
            }
            if (!bl) {
                if (n7 < n6) continue;
                n7 = n5;
                n6 = n8;
            }
            if (n7 > n6) continue;
            HitInfo hitInfo = new HitInfo();
            hitInfo.a = foldingSpan;
            int n13 = n5;
            int n14 = n9;
            if (!bl) {
                if (n13 == n14) {
                    hitInfo.b = 0;
                    return hitInfo;
                }
                n13 = n5;
                n14 = n8;
            }
            if (n13 != n14) continue;
            hitInfo.b = 0;
            return hitInfo;
        }
        return null;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this.setMarginSupport(new CodeEditorMarginSupport(codeEditor));
        super.setCodeEditor(codeEditor);
    }

    protected static class HitInfo {
        FoldingSpan a;
        int b;

        protected HitInfo() {
        }
    }
}

