/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.BridgeServiceCommandAction;
import ch.e2e.builder.compiler.net.VariableStore;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ParallelRequestTest
extends TestCase {
    private String method;
    private String protocol;
    private String host;
    private Integer port;
    private String urlPath;
    private String requestFilename;
    private File requestsDir;
    private File controlDir;
    private File logDir;
    private Collection<String> ignoredAttributes;
    private Collection<String> ignoredElements;
    private File header;
    private String variable;
    private String variableXPath;

    ParallelRequestTest(String name, String method, String protocol, String host, Integer port, String urlPath, String requestFilename, File requestsDir, File controlDir, File logDir, Collection<String> ignoredAttributes, Collection<String> ignoredElements, File header) {
        super(name);
        this.method = method;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.urlPath = urlPath;
        this.requestFilename = requestFilename;
        this.requestsDir = requestsDir;
        this.controlDir = controlDir;
        this.logDir = logDir;
        this.ignoredAttributes = ignoredAttributes;
        this.ignoredElements = ignoredElements;
        this.header = header;
    }

    protected void runTest() throws Throwable {
        Object additionalHeaders;
        File requestFile;
        String request = null;
        VariableStore variableStore = new VariableStore(this.variable != null && !this.variable.isEmpty() ? new File(this.logDir, this.variable + ".store") : null);
        if (!this.method.equalsIgnoreCase("GET") && (requestFile = new File(this.requestsDir, this.requestFilename)).exists()) {
            StringWriter requestWriter = new StringWriter();
            FileUtilities.copy((Reader)new InputStreamReader((InputStream)new FileInputStream(requestFile), "UTF-8"), (Writer)requestWriter);
            request = variableStore.expandVariables(requestWriter.toString());
        }
        BridgeServiceCommandAction action = new BridgeServiceCommandAction();
        if (this.header == null) {
            HashMap<String, String> additionalHeadersMap = new HashMap<String, String>();
            additionalHeadersMap.put("X-Bridge", "NoErrorReturn");
            additionalHeaders = additionalHeadersMap;
        } else {
            additionalHeaders = new Properties(this.header);
        }
        InputStream rawResult = action.configureService(this.method, this.protocol, this.host, this.port, this.urlPath, request, (Map)additionalHeaders);
        BufferedInputStream result = new BufferedInputStream(rawResult);
        result.mark(1000000);
        String logFilename = this.getName() + ".log";
        File logfile = new File(this.logDir, logFilename);
        logfile.delete();
        logfile.getParentFile().mkdirs();
        boolean logFileEmpty = true;
        byte[] buffer = new byte[10000];
        try (FileOutputStream logStream = new FileOutputStream(logfile);){
            int amountRead;
            while ((amountRead = result.read(buffer)) != -1) {
                logFileEmpty = false;
                logStream.write(buffer, 0, amountRead);
            }
        }
        if (!logFileEmpty) {
            variableStore.extractVariableValue(this.variableXPath, this.variable, new FileInputStream(logfile));
            File controlFile = new File(this.controlDir, logFilename);
            this.assertEqualFiles(controlFile, logfile);
        }
    }

    private void assertEqualFiles(File controlFile, File responseFile) throws IOException, ParserConfigurationException, SAXException {
        ParallelRequestTest.assertTrue((String)(this.getName() + ": Control file " + controlFile.getAbsolutePath() + " does not exists."), (boolean)controlFile.exists());
        ParallelRequestTest.assertTrue((String)(this.getName() + ": Response file " + responseFile.getAbsolutePath() + " does not exists."), (boolean)responseFile.exists());
        Document controlDocument = DomUtilities.parse((File)controlFile, (boolean)false, (boolean)false);
        Document destinationDocument = DomUtilities.parse((File)responseFile, (boolean)false, (boolean)false);
        E2EComparisonController controller = new E2EComparisonController();
        E2EDifferenceEngine DiffEngine = new E2EDifferenceEngine((ComparisonController)controller, this.ignoredAttributes, this.ignoredElements);
        E2EDiff diff = new E2EDiff(controlDocument, destinationDocument, (DifferenceEngine)DiffEngine, controlFile.getAbsolutePath());
        XMLAssert.assertXMLIdentical((String)(this.getName() + ": XML not equal for " + controlFile.getAbsolutePath()), (Diff)diff, (boolean)true);
    }

    void setVariable(String variable) {
        this.variable = variable;
    }

    void setVariableXPath(String variableXPath) {
        this.variableXPath = variableXPath;
    }

    public String toString() {
        return this.getName();
    }
}

