/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.XMLCompare;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ErrorCompare
extends XMLCompare {
    private String umlFilename;
    private String logfile;

    public void doTest(E2ETest test) throws IOException, ParserConfigurationException, SAXException, TransformerException, TransformerLoadException, XPathExpressionException {
        File srcFolder = CompilerConstants.getSourceFolder();
        File umlFile = new File(srcFolder, this.umlFilename);
        File projectFolder = new File(E2EBuilderProject.locateProjectHome((File)umlFile));
        UmlDocumentCompilerSettings compilerSettings = new UmlDocumentCompilerSettings(projectFolder);
        compilerSettings.setUmlSourceFolder(srcFolder);
        UmlDocument umlDocument = new UmlDocumentFactory(compilerSettings).getUmlDocument(umlFile);
        String logfileName = StringTools.replaceProperty((String)this.logfile, (String)"document.id", (String)umlDocument.getUniqueId());
        File errorFolder = new File(umlDocument.getDocumentWorkingFolder(), "errorlog");
        File errors = new File(errorFolder, logfileName + ".errors");
        this.setTestFile(new CompareFile(errors));
        super.doTest(test);
    }

    public void init(Element options) {
        NodeList logfiles;
        super.init(options);
        NodeList umlDocuments = options.getElementsByTagName("umldocument");
        if (umlDocuments != null && umlDocuments.getLength() == 1) {
            this.umlFilename = ((Element)umlDocuments.item(0)).getAttribute("name");
        }
        if ((logfiles = options.getElementsByTagName("logfile")) != null && logfiles.getLength() == 1) {
            this.logfile = ((Element)logfiles.item(0)).getAttribute("name");
        }
    }

    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
    }
}

