/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.BuildRepositoryTest;
import ch.e2e.builder.compiler.build.process.CompileProcess;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.InputComboBox;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.RegexTextField;
import ch.e2e.swing.model.SortedComboBoxModel;
import ch.e2e.test.TypeFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class BuildRepositoryCreateDialog
extends ModalDialog {
    private static final Icon E2EBUILDER_LOGO = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/test/images/Y-32x32.png", (boolean)true, (ClassLoader)BuildRepositoryCreateDialog.class.getClassLoader());
    private static BuildRepositoryCreateDialog dlg;
    private RegexTextField documentField;
    private Frame owner;
    private SortedComboBoxModel<Deployment> deploymentModel;
    private RegexTextField repositoryField;
    private RegexTextField projectFolderField;
    private File lastFolderSelection;

    private BuildRepositoryCreateDialog(Frame owner) {
        super(owner, "Create a new Build Repository Test", "Create a new Build Repository Test", "", E2EBUILDER_LOGO, 3, false);
        this.owner = owner;
        String projectHome = System.getProperty("ch.e2e.builder.base.home");
        this.lastFolderSelection = new File(projectHome == null ? "" : projectHome);
        this.createGui();
    }

    public static BuildRepositoryTest createTest(Frame owner) {
        if (dlg == null) {
            dlg = new BuildRepositoryCreateDialog(owner);
        }
        return dlg.create();
    }

    public BuildRepositoryTest create() {
        this.documentField.setText("");
        this.setOkButtonEnabled(false);
        BuildRepositoryTest result = null;
        if (this.showDialog() == 1) {
            try {
                result = (BuildRepositoryTest)TypeFactory.getInstance().getType("buildRepositoryTest").newInstance();
                result.setOption("compile.test.uml.document", this.documentField.getText());
                result.setOption("compile.test.deployment", ((Deployment)this.deploymentModel.getSelectedItem()).getName());
                if (!this.repositoryField.getText().isEmpty()) {
                    result.setOption("compile.test.repository", this.repositoryField.getText());
                }
                if (!this.projectFolderField.getText().isEmpty()) {
                    result.setOption("compile.test.project.folder", this.projectFolderField.getText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(3, 11, 1, 7);
        JLabel nameLabel = new JLabel("Uml Document");
        this.add(nameLabel, c);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(2, 10, 5, 7);
        Properties properties = new Properties("ch.e2e.swing.swing");
        this.documentField = new RegexTextField(properties.getString("absolutepath.pattern"));
        this.add((Component)this.documentField, c);
        this.documentField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                BuildRepositoryCreateDialog.this.inputChanged();
            }
        });
        this.documentField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = BuildRepositoryCreateDialog.this.documentField.getText();
                return text.isEmpty() || new File(text).isFile();
            }
        });
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 5, 10);
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildRepositoryCreateDialog.this.browseUmlDocument();
            }
        });
        this.add(browseButton, c);
        c.gridwidth = 0;
        c.insets = new Insets(5, 11, 1, 7);
        JLabel deploymentLabel = new JLabel("Deployment");
        this.add(deploymentLabel, c);
        this.deploymentModel = new SortedComboBoxModel();
        InputComboBox comboBox = new InputComboBox();
        comboBox.setModel(this.deploymentModel);
        c.insets = new Insets(2, 10, 5, 7);
        this.add((Component)comboBox, c);
        c.insets = new Insets(5, 11, 1, 7);
        JLabel projectFolderLabel = new JLabel("Project Folder");
        c.insets = new Insets(5, 11, 1, 7);
        this.add(projectFolderLabel, c);
        this.projectFolderField = new RegexTextField(properties.getString("absolutepath.pattern"));
        c.gridwidth = 1;
        this.add((Component)this.projectFolderField, c);
        this.projectFolderField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = BuildRepositoryCreateDialog.this.documentField.getText();
                return text.isEmpty() || new File(text).isFile();
            }
        });
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 5, 10);
        c.gridwidth = 0;
        JButton projectFolderBrowseButton = new JButton("...");
        projectFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildRepositoryCreateDialog.this.browseProjectFolder();
            }
        });
        this.add(projectFolderBrowseButton, c);
    }

    private void browseUmlDocument() {
        JFileChooser fileChooser = new JFileChooser(this.lastFolderSelection);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("UML Model (*.xml, *.xml.zip)", "xml", "xml.zip"));
        if (fileChooser.showOpenDialog(this.owner) == 0) {
            this.lastFolderSelection = fileChooser.getCurrentDirectory();
            this.documentField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void browseProjectFolder() {
        JFileChooser fileChooser = new JFileChooser(this.lastFolderSelection);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this.owner) == 0) {
            this.lastFolderSelection = fileChooser.getCurrentDirectory();
            this.projectFolderField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void inputChanged() {
        this.clearDeploymentBox();
        File file = new File(this.documentField.getText());
        if (!this.documentField.getText().isEmpty() && file.exists()) {
            ArrayList allDeployments;
            File projectsFolder = new File(E2EBuilderProject.locateProjectHome((File)file));
            UmlDocument umlDocument = new UmlDocumentFactory(new UmlDocumentCompilerSettings(projectsFolder)).getUmlDocument(file);
            new CompileProcess(umlDocument).run("Xmi2Descriptor_Task");
            ArrayList arrayList = allDeployments = umlDocument.hasDescriptor() ? umlDocument.getDescriptor().getAllDeployments() : new ArrayList();
            if (allDeployments.size() > 0) {
                this.deploymentModel.addAll(allDeployments);
                this.deploymentModel.setSelectedItem(allDeployments.get(0));
            }
            try {
                this.projectFolderField.setText(new File(projectsFolder, ".e2ebuilder").exists() ? projectsFolder.getAbsolutePath() : "");
            }
            catch (Exception e) {
                this.projectFolderField.setText("");
            }
        }
        this.setOkButtonEnabled(this.deploymentModel.getSelectedItem() != null);
    }

    private void clearDeploymentBox() {
        this.deploymentModel.clear();
        this.deploymentModel.setSelectedItem(null);
    }
}

