/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.action.DeployBuildAction;
import ch.e2e.builder.compiler.build.action.DeployDeploymentBuildAction;
import ch.e2e.builder.compiler.build.process.DeployCompositeProcess;
import ch.e2e.builder.compiler.build.test.DeployResultCompare;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.secure.HttpsUtil;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2EAssert;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.Utilities;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.PasswordOption;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.util.ArrayList;

public class DeployTest
extends E2ETest {
    public static final String KEY_TEST_TYPE_NAME = "DeployRepository";
    public static final String KEY_OPTION_LOGFILE = "repository.deploy.logfile";
    public static final String KEY_OPTION_HOST = "repository.deploy.url.host";
    public static final String KEY_OPTION_PORT = "repository.deploy.url.port";
    public static final String KEY_OPTION_USERNAME = "repository.deploy.auth.user";
    public static final String KEY_OPTION_PASSWORD = "repository.deploy.auth.password";
    public static final String KEY_OPTION_DO_STARTUP = "repository.deploy.start";
    public static final String KEY_OPTION_DO_OVERRIDE = "repository.deploy.override";
    public static final String KEY_OPTION_DO_OVERRIDE_SETTINGS = "repository.deploy.override.settings";
    public static final String KEY_OPTION_REPOSITORY_FILE = "repository.deploy.file";

    public void doTest() throws Exception {
        String host = (String)this.getOptionValue(KEY_OPTION_HOST);
        Integer port = (Integer)this.getOptionValue(KEY_OPTION_PORT);
        String username = (String)this.getOptionValue(KEY_OPTION_USERNAME);
        DeployTest.assertFalse((String)"Username not set", (username == null ? 1 : 0) != 0);
        String password = (String)this.getOptionValue(KEY_OPTION_PASSWORD);
        DeployTest.assertFalse((String)"Password not set", (password == null ? 1 : 0) != 0);
        File repository = (File)this.getOptionValue(KEY_OPTION_REPOSITORY_FILE);
        DeployTest.assertFalse((String)"Repository file not set", (repository == null ? 1 : 0) != 0);
        DeployTest.assertTrue((String)("Repository '" + repository.getAbsolutePath() + "' does not exist."), (boolean)repository.exists());
        File errorLogfile = (File)this.getOptionValue(KEY_OPTION_LOGFILE);
        Boolean startup = (Boolean)this.getOptionValue(KEY_OPTION_DO_STARTUP);
        Boolean override = (Boolean)this.getOptionValue(KEY_OPTION_DO_OVERRIDE);
        Boolean overrideSettings = (Boolean)this.getOptionValue(KEY_OPTION_DO_OVERRIDE_SETTINGS);
        Login login = new Login(username, password, host, port.intValue());
        DeployDeploymentBuildAction action = new DeployDeploymentBuildAction(repository, login, startup.booleanValue(), override.booleanValue(), overrideSettings.booleanValue(), new DeployErrorHandler(errorLogfile));
        new DeployCompositeProcess().start((DeployBuildAction)action);
        DeployErrorHandler errorHandler = action.getErrorHandler();
        if (errorHandler.getErrorCount() > 0) {
            ArrayList<ErrorDetail> errorDetails = this.fillErrorDetails(errorHandler);
            E2EAssert.fail((String)("Deployment of " + repository.getAbsolutePath() + " to " + host + " failed."), errorDetails);
        }
    }

    private ArrayList<ErrorDetail> fillErrorDetails(DeployErrorHandler errorHandler) {
        ArrayList<ErrorDetail> errorDetails = new ArrayList<ErrorDetail>();
        for (AbstractBuilderError error : errorHandler.getErrors()) {
            errorDetails.add(new ErrorDetail((Object)error.getCode()));
        }
        for (AbstractBuilderError error : errorHandler.getFatalErrors()) {
            errorDetails.add(new ErrorDetail((Object)error.getCode()));
        }
        return errorDetails;
    }

    public String getRecommendedCompareType() {
        return "DeployResultCompare";
    }

    public void setName(StringOption nameOption) {
        nameOption.addDependency(KEY_OPTION_REPOSITORY_FILE);
        nameOption.setDependencyString("Deploy ${repository.deploy.file.name}");
        nameOption.setDefaultValue((Object)"Deploy ${repository.deploy.file.name}");
        super.setName(nameOption);
    }

    public void prepareCompareType(ResultCompare compare) {
        FileOption testFile;
        if (compare instanceof DeployResultCompare) {
            testFile = (FileOption)compare.getOptions().get("deploy.result.compare.test.file");
            testFile.addDependency(KEY_OPTION_LOGFILE);
            testFile.setDependencyString("${repository.deploy.logfile}");
            testFile.setDefaultValue((Object)new File("${repository.deploy.logfile}"));
        } else if (compare instanceof XMLCompare) {
            testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
            testFile.addDependency(KEY_OPTION_LOGFILE);
            testFile.setDependencyString("${repository.deploy.logfile}");
            testFile.setDefaultValue((Object)new CompareFile(new File("${repository.deploy.logfile}")));
            CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
            File defaultValue = new File(this.getReferenceFolder(), "${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log");
            referenceFile.addDependency(KEY_OPTION_REPOSITORY_FILE);
            referenceFile.addDependency(KEY_OPTION_HOST);
            referenceFile.setDependencyString(defaultValue.getAbsolutePath());
            referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
        }
        StringOption nameOption = (StringOption)compare.getOptions().get("key.option.result.compare.name");
        String defaultName = "Compare ${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log";
        nameOption.addDependency(KEY_OPTION_REPOSITORY_FILE);
        nameOption.addDependency(KEY_OPTION_HOST);
        nameOption.setDependencyString(defaultName);
        nameOption.setDefaultValue((Object)defaultName);
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption logfile = (FileOption)this.getOptions().get(KEY_OPTION_LOGFILE);
        File defaultValue = new File(testFolder, "${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log");
        logfile.setDependencyString(defaultValue.getAbsolutePath());
        logfile.setDefaultValue((Object)defaultValue);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                FileOption testFile;
                if (compare instanceof DeployResultCompare) {
                    testFile = (FileOption)compare.getOptions().get("deploy.result.compare.test.file");
                    testFile.setDependencyString("${repository.deploy.logfile}");
                    testFile.setDefaultValue((Object)new File("${repository.deploy.logfile}"));
                    continue;
                }
                if (!(compare instanceof XMLCompare)) continue;
                testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
                testFile.setDependencyString("${repository.deploy.logfile}");
                testFile.setDefaultValue((Object)new CompareFile(new File("${repository.deploy.logfile}")));
            }
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (compare instanceof DeployResultCompare || !(compare instanceof XMLCompare)) continue;
                CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(referenceFolder, "${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log");
                referenceFile.setDependencyString(defaultValue.getAbsolutePath());
                referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            }
        }
    }

    public void removeOutputData() {
        File logfile = (File)this.getOptionValue(KEY_OPTION_LOGFILE);
        if (logfile != null) {
            logfile.delete();
            Utilities.deleteEmptyParents((File)logfile);
        }
    }

    protected void createOptions() {
        FileOption repositoryFile = new FileOption("Repository File", KEY_OPTION_REPOSITORY_FILE, 0);
        repositoryFile.setRequired(true);
        repositoryFile.addFileExtension("rep", "E2E Bridge repository (*.rep)");
        repositoryFile.addFileExtension("jar", "Java repository (*.jar)");
        repositoryFile.addFileExtension("zip", "Node.js repository (*.zip)");
        this.addOption(KEY_OPTION_REPOSITORY_FILE, (Option)repositoryFile);
        StringOption host = new StringOption("Host", KEY_OPTION_HOST, "localhost", 1);
        host.setRequired(true);
        this.addOption(KEY_OPTION_HOST, (Option)host);
        IntegerOption port = new IntegerOption("Port", KEY_OPTION_PORT, Integer.valueOf(8080), 2);
        port.setMaxValue(99999);
        port.setMinValue(1);
        port.setRequired(true);
        this.addOption(KEY_OPTION_PORT, (Option)port);
        StringOption userOption = new StringOption("Username", KEY_OPTION_USERNAME, null, 3);
        userOption.setRequired(true);
        this.addOption(KEY_OPTION_USERNAME, (Option)userOption);
        PasswordOption passwordOption = new PasswordOption("Password", KEY_OPTION_PASSWORD, 4);
        passwordOption.setRequired(true);
        this.addOption(KEY_OPTION_PASSWORD, (Option)passwordOption);
        this.addOption(KEY_OPTION_DO_OVERRIDE, (Option)new BooleanOption("Override existing", "Should not exist", KEY_OPTION_DO_OVERRIDE, true, true, 6));
        this.addOption(KEY_OPTION_DO_OVERRIDE_SETTINGS, (Option)new BooleanOption("Override settings", "Keep changed settings", KEY_OPTION_DO_OVERRIDE_SETTINGS, true, false, 7));
        this.addOption(KEY_OPTION_DO_STARTUP, (Option)new BooleanOption("Start service", "Do not start service", KEY_OPTION_DO_STARTUP, true, false, 8));
        FileOption logfile = new FileOption("Logfile", KEY_OPTION_LOGFILE, new File("${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log"), 9);
        logfile.addDependency(KEY_OPTION_REPOSITORY_FILE);
        logfile.addDependency(KEY_OPTION_HOST);
        logfile.setDependencyString("${repository.deploy.file.name}/${repository.deploy.url.host}.deploy.log");
        logfile.setRequired(true);
        logfile.addFileExtension("log", "Logfile");
        this.addOption(KEY_OPTION_LOGFILE, (Option)logfile);
    }

    static {
        HttpsUtil.initialize();
    }
}

