/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.process.CompileProcess;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.RepositoryDescriptor;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestSource;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class CompileTest
extends E2ETest {
    public void doTest() throws Exception {
        E2ETestSource projectHomeSource = this.getSource("projectHome");
        CompileTest.assertFalse((String)"Element <source name=\"projectHome\" type=\"file\" value=\"...\" /> must be defined.", (projectHomeSource == null ? 1 : 0) != 0);
        File projectHome = (File)projectHomeSource.getValue();
        CompileTest.assertTrue((String)("Projecthome '" + projectHome.getAbsolutePath() + "' does not exists"), (boolean)projectHome.exists());
        new E2EBuilderProject(projectHome);
        UmlDocumentCompilerSettings compilerSettings = new UmlDocumentCompilerSettings(projectHome);
        File srcFolder = compilerSettings.getUmlSourceFolder();
        CompileTest.assertTrue((String)("Sourcefolder " + srcFolder.getAbsolutePath() + " does not exists"), (boolean)srcFolder.exists());
        UmlDocumentFactory factory = new UmlDocumentFactory(compilerSettings);
        this.checkDescriptors(srcFolder, factory);
        this.buildDocuments(srcFolder, factory);
        this.buildConfigurations(srcFolder, factory);
    }

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    private void buildConfigurations(File srcFolder, UmlDocumentFactory umlDocumentFactory) {
        Composite[] configurations;
        for (Composite composite : configurations = this.getBuildConfigurations(srcFolder, umlDocumentFactory)) {
            new CompileProcess(composite.getUmlDocument(), composite.getName()).run("Repository_Task");
        }
    }

    private Composite[] getBuildConfigurations(File srcFolder, UmlDocumentFactory umlDocumentFactory) {
        ArrayList sources = this.getSources("configuration");
        ArrayList<Composite> configurations = new ArrayList<Composite>();
        boolean ignoreMissingDocument = StringTools.createBoolean((String)((String)this.getProperties().get("ignoreMissingDocument")));
        if (sources != null) {
            for (E2ETestSource source : sources) {
                String configurationName = (String)source.getValue();
                File documentFile = (File)source.getOption("umldocument");
                if (!documentFile.isAbsolute()) {
                    documentFile = new File(srcFolder, documentFile.getPath());
                }
                CompileTest.assertTrue((String)("Umldocument '" + documentFile.getAbsolutePath() + "' does not exist."), (ignoreMissingDocument || documentFile.exists() ? 1 : 0) != 0);
                if (documentFile.exists()) {
                    UmlDocument umlDocument = umlDocumentFactory.getUmlDocument(documentFile);
                    CompileTest.assertNotNull((String)("Could not load UmlDocument '" + documentFile.getAbsolutePath() + "'."), (Object)umlDocument);
                    RepositoryDescriptor descriptor = umlDocument.getDescriptor();
                    CompileTest.assertNotNull((String)("No descriptor found in '" + documentFile.getAbsolutePath() + "'."), (Object)descriptor);
                    Composite composite = (Composite)descriptor.getCompilableObject(configurationName);
                    CompileTest.assertNotNull((String)("Configuration '" + configurationName + "' not found in '" + documentFile.getAbsolutePath() + "'"), (Object)composite);
                    configurations.add(composite);
                    new CompileProcess(umlDocument).run("Clean_All_Task");
                    if (!source.hasOption("cleanWorkFolder") || !((Boolean)source.getOption("cleanWorkFolder")).booleanValue()) continue;
                    FileUtilities.silentDeleteAll((File)umlDocument.getSettings().getWorkFolder());
                    continue;
                }
                this.log("Umldocument '" + documentFile.getAbsolutePath() + "' does not exist.");
            }
        }
        Composite[] result = new Composite[configurations.size()];
        configurations.toArray(result);
        return result;
    }

    private void buildDocuments(File srcFolder, UmlDocumentFactory umlDocumentFactory) {
        ArrayList<UmlDocument> buildDocuments = this.getBuildDocuments(srcFolder, umlDocumentFactory);
        for (UmlDocument umlDocument : buildDocuments) {
            new CompileProcess(umlDocument).run("All_Xmi2Tab_Task");
        }
    }

    private ArrayList<UmlDocument> getBuildDocuments(File srcFolder, UmlDocumentFactory umlDocumentFactory) {
        ArrayList documents = this.getSources("umldocument");
        ArrayList<UmlDocument> umlDocuments = new ArrayList<UmlDocument>();
        if (documents != null) {
            for (E2ETestSource source : documents) {
                File documentFile = (File)source.getValue();
                if (!documentFile.isAbsolute()) {
                    documentFile = new File(srcFolder, documentFile.getPath());
                }
                CompileTest.assertTrue((String)("Document '" + documentFile.getAbsolutePath() + "' does not exists"), (boolean)documentFile.exists());
                UmlDocument umlDocument = umlDocumentFactory.getUmlDocument(documentFile);
                umlDocuments.add(umlDocument);
                new CompileProcess(umlDocument).run("Clean_All_Task");
                if (!source.hasOption("cleanWorkFolder") || !((Boolean)source.getOption("cleanWorkFolder")).booleanValue()) continue;
                FileUtilities.silentDeleteAll((File)umlDocument.getSettings().getWorkFolder());
            }
        }
        return umlDocuments;
    }

    private void checkDescriptors(File srcFolder, UmlDocumentFactory umlDocumentFactory) {
        File[] documentFiles;
        umlDocumentFactory.cleanAll();
        for (File documentFile : documentFiles = FileUtilities.getFileList((File)srcFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.getName().endsWith(".xml.zip") || path.getName().endsWith(".xml");
            }
        }, (boolean)true)) {
            UmlDocument umlDocument = umlDocumentFactory.getUmlDocument(documentFile);
            new CompileProcess(umlDocument).run("Xmi2Descriptor_Task");
        }
    }
}

