/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase.response;

import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.response.AbstractResponseParser;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResponseParser
extends AbstractResponseParser {
    protected UmlTree createUmlTree(Document traceDocument, AbstractSynchronousTestcase testcase) {
        UmlTree umlTree = null;
        if (traceDocument != null) {
            TraceSettings traceSettings = testcase.getTraceSettings();
            NodeList traces = traceDocument.getDocumentElement().getElementsByTagNameNS("http://e2e.ch/bridge", "Trace");
            if (traces != null && traces.getLength() == 1) {
                Element trace = (Element)traces.item(0);
                this.serverVersion = trace.getAttributeNS("http://e2e.ch/bridge", "Version");
                umlTree = this.createUmlTree(trace, traceSettings);
            }
        }
        return umlTree;
    }

    protected UmlTree createUmlTree(Document traceDocument, AbstractAsynchronousTestcase testcase) {
        UmlTree umlTree = null;
        if (traceDocument != null) {
            NodeList traces = traceDocument.getElementsByTagNameNS("http://e2e.ch/bridge", "TraceLog");
            if (traces != null && traces.getLength() == 1) {
                Element trace = (Element)traces.item(0);
                this.serverVersion = trace.getAttributeNS("http://e2e.ch/bridge", "Version");
                umlTree = this.createUmlTree(trace, testcase.getTraceSettings());
            } else {
                this.serverVersion = null;
            }
        }
        return umlTree;
    }

    protected void createSystemDocument(AbstractSynchronousTestcase testcase, Instant runtime, String serverVersion, UmlTree umlTree) throws TransformerException, IOException {
        String traceLevelStr;
        Document result = DomUtilities.newDocument((String)"System");
        Element root = result.getDocumentElement();
        Element soapAction = result.createElement("soapAction");
        soapAction.appendChild(result.createTextNode(testcase.getSoapAction()));
        root.appendChild(soapAction);
        Element documentStyle = result.createElement("documentStyle");
        documentStyle.appendChild(result.createTextNode(testcase.isRPCEncoding() ? "rpc" : "document"));
        root.appendChild(documentStyle);
        serverVersion = serverVersion != null && this.VERSION_FINDER.reset(serverVersion).matches() ? this.VERSION_FINDER.group().replace('_', '.') : "unkown";
        Element version = result.createElement("version");
        version.appendChild(result.createTextNode(serverVersion));
        root.appendChild(version);
        Element lastRun = result.createElement("lastRun");
        Element date = result.createElement("date");
        date.appendChild(result.createTextNode(runtime.toString()));
        lastRun.appendChild(date);
        Element location = result.createElement("location");
        location.appendChild(result.createTextNode(testcase.getLocation()));
        lastRun.appendChild(location);
        Element trace = result.createElement("Trace");
        Element traceLevel = result.createElement("tracelevel");
        if (testcase.getTraceSettings().isEnabled()) {
            if (umlTree != null) {
                String string = traceLevelStr = testcase.getTraceSettings().getTraceLevel() == TraceSettings.TraceLevel.Full ? TraceSettings.TraceLevel.Full.toString() : TraceSettings.TraceLevel.Moderate.toString();
                if (umlTree.hasTraceError()) {
                    Element traceError = result.createElement("TraceError");
                    traceError.appendChild(result.createTextNode(umlTree.getTraceError().getMessage()));
                    trace.appendChild(traceError);
                }
            } else {
                traceLevelStr = "Compiled without trace";
            }
        } else {
            traceLevelStr = "None";
        }
        traceLevel.appendChild(result.createTextNode(traceLevelStr));
        trace.appendChild(traceLevel);
        lastRun.appendChild(trace);
        root.appendChild(lastRun);
        DomUtilities.serialize((File)new File(testcase.getTraceFolder(), "system.info"), (Document)result, (boolean)false);
    }

    protected Document createSystemDocument(AbstractAsynchronousTestcase testcase, Instant runtime, String serverVersion, UmlTree umlTree) {
        String traceLevelStr;
        Document result = DomUtilities.newDocument((String)"System");
        Element root = result.getDocumentElement();
        if (serverVersion == null) {
            serverVersion = "unknown";
        } else {
            int index = serverVersion.indexOf(95);
            if (index != -1) {
                serverVersion = serverVersion.substring(index + 1).replace('_', '.');
            }
        }
        Element version = result.createElement("version");
        version.appendChild(result.createTextNode(serverVersion));
        root.appendChild(version);
        Element lastRun = result.createElement("lastRun");
        Element date = result.createElement("date");
        date.appendChild(result.createTextNode(runtime.toString()));
        lastRun.appendChild(date);
        Element location = result.createElement("location");
        location.appendChild(result.createTextNode(testcase.getLocation()));
        lastRun.appendChild(location);
        Element trace = result.createElement("Trace");
        Element traceLevel = result.createElement("tracelevel");
        if (testcase.getTraceSettings().isEnabled()) {
            if (umlTree != null) {
                String string = traceLevelStr = testcase.getTraceSettings().getTraceLevel() == TraceSettings.TraceLevel.Full ? TraceSettings.TraceLevel.Full.toString() : TraceSettings.TraceLevel.Moderate.toString();
                if (umlTree.hasTraceError()) {
                    Element traceError = result.createElement("TraceError");
                    traceError.appendChild(result.createTextNode(umlTree.getTraceError().getMessage()));
                    trace.appendChild(traceError);
                }
            } else {
                traceLevelStr = "Compiled without trace";
            }
        } else {
            traceLevelStr = "None";
        }
        traceLevel.appendChild(result.createTextNode(traceLevelStr));
        trace.appendChild(traceLevel);
        lastRun.appendChild(trace);
        root.appendChild(lastRun);
        return result;
    }
}

