/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.swing.util.FileChooserFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class FileFilterComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private ArrayList filter = new ArrayList();
    private FileChooserFilter selectedFilter;

    public FileFilterComboBoxModel() {
    }

    public FileFilterComboBoxModel(FileChooserFilter[] fileFilter) {
        this.filter.addAll(Arrays.asList(fileFilter));
    }

    public void addFileFilter(FileChooserFilter fileFilter) {
        if (!this.filter.contains(fileFilter)) {
            this.filter.add(fileFilter);
        }
    }

    public void setFileFilter(FileChooserFilter[] fileFilter) {
        this.filter.clear();
        this.filter.addAll(Arrays.asList(fileFilter));
    }

    @Override
    public int getSize() {
        return this.filter.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.filter.get(index);
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        if (this.selectedFilter == null || !selectedItem.equals(this.selectedFilter)) {
            this.selectedFilter = (FileChooserFilter)selectedItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public FileChooserFilter getSelectedFilter() {
        return (FileChooserFilter)this.getSelectedItem();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedFilter;
    }

    @Override
    public void removeElementAt(int index) {
        this.filter.remove(index);
        this.fireContentsChanged(this, -1, -1);
    }

    public void insertElementAt(Object fileFilter, int index) {
        this.filter.add(index, fileFilter);
        this.fireContentsChanged(this, -1, -1);
    }

    public int getIndexOf(Object fileFilter) {
        return this.filter.indexOf(fileFilter);
    }

    @Override
    public void removeElement(Object fileFilter) {
        this.filter.remove(fileFilter);
        this.fireContentsChanged(this, -1, -1);
    }

    public void removeAllElements() {
        this.filter.clear();
        this.fireContentsChanged(this, -1, -1);
    }

    public void addElement(Object fileFilter) {
        this.filter.add(fileFilter);
        this.fireContentsChanged(this, -1, -1);
    }
}

