/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.DirectoryTreeModelExtension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.tree.TreePath;

public class DirectoryTreeModel
extends AbstractTreeModel {
    private Directory root;
    private ActionListener executeAction;
    private DirectoryTreeModelExtension extension;

    public DirectoryTreeModel(Directory root) {
        super("ch.e2e.swing.filechooser.directorytree");
        this.root = root == null ? Directory.getRoot() : root;
    }

    public void setRoot(Directory root) {
        this.root = root;
        this.fireRootChanged();
        TreePath path = new TreePath("");
        this.fireTreeStructureChanged(path);
    }

    public void setExtension(DirectoryTreeModelExtension extension) {
        this.getProperties().addProperties(extension.getPropertiesExtension());
        this.extension = extension;
    }

    public void setExecuteAction(ActionListener executeAction) {
        this.executeAction = executeAction;
    }

    public ActionListener getExecuteAction(Object value) {
        return this.executeAction;
    }

    public TreePath setSelectedDirectory(File selectedDirectory) {
        return this.setSelectedDirectory(Directory.getDirectory(selectedDirectory));
    }

    public TreePath setSelectedDirectory(Directory selectedDirectory) {
        if (!selectedDirectory.isRoot()) {
            while (selectedDirectory.getDir() != null && !selectedDirectory.getDir().exists()) {
                selectedDirectory = selectedDirectory.getParent();
            }
        }
        Object[] path = selectedDirectory.getPathToRoot();
        TreePath treePath = new TreePath(path);
        return treePath;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((Directory)parent).indexOfExisting((Directory)child);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((Directory)node).sizeExisting() == 0;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((Directory)parent).sizeExisting();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((Directory)parent).getExisting(index);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object[][] getDefaultTypes() {
        return new Object[][]{{new Integer(0), "filesystem"}, {new Integer(1), "disc"}, {new Integer(2), "folder"}};
    }

    @Override
    public String getTypeString(int type) {
        String result = null;
        if (this.extension != null) {
            result = this.extension.getTypeString(type);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public int getType(Object value) {
        Directory dir = (Directory)value;
        return dir.getType(this.extension);
    }

    @Override
    public Font getFont(Object value, Font originalFont) {
        Directory dir = (Directory)value;
        Font font = this.extension != null && this.extension.getFont(dir.getDir(), originalFont) != null ? this.extension.getFont(dir.getDir(), originalFont) : originalFont;
        return font;
    }
}

