/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.event.RootChangedEvent;
import ch.e2e.swing.event.RootChangedEventMulticaster;
import ch.e2e.swing.event.RootChangedListener;
import ch.e2e.swing.event.TreeModelEventMulticaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    private TreeModelListener treeModelListener;
    private Properties properties = null;
    private RootChangedListener rootChangedListener;

    public AbstractTreeModel() {
        this((Properties)null);
    }

    public AbstractTreeModel(String properties) {
        this(properties, AbstractTreeModel.class.getClassLoader());
    }

    public AbstractTreeModel(String properties, ClassLoader classLoader) {
        this((Properties)new MultiMapProperties(properties, "tree_maps", classLoader));
    }

    public AbstractTreeModel(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addRootChangedListener(RootChangedListener rootChangedListener) {
        this.rootChangedListener = RootChangedEventMulticaster.addListener(this.rootChangedListener, rootChangedListener);
    }

    public void removeRootChangedListener(RootChangedListener rootChangedListener) {
        this.rootChangedListener = RootChangedEventMulticaster.removeListener(this.rootChangedListener, rootChangedListener);
    }

    protected void fireRootChanged() {
        if (this.rootChangedListener != null) {
            this.rootChangedListener.rootChanged(new RootChangedEvent(this));
        }
    }

    @Override
    public abstract Object getRoot();

    @Override
    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent instanceof TreeObject) {
            result = ((TreeObject)parent).getChild(index);
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int result = 0;
        if (parent instanceof TreeObject) {
            result = ((TreeObject)parent).getChildCount();
        }
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean result = true;
        if (node instanceof TreeObject) {
            result = ((TreeObject)node).isLeaf();
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        if (parent instanceof TreeObject) {
            result = ((TreeObject)parent).getIndexOfChild(child);
        }
        return result;
    }

    @Override
    public abstract void valueForPathChanged(TreePath var1, Object var2);

    public int getType(Object value) {
        int result = -1;
        if (value instanceof TreeObject) {
            result = ((TreeObject)value).getType();
        }
        return result;
    }

    public abstract String getTypeString(int var1);

    public Icon getTypeIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        return null;
    }

    public Color getTypeColor(int type, boolean leaf, boolean expanded, boolean selected) {
        return null;
    }

    public Object[][] getDefaultTypes() {
        return new Object[0][];
    }

    public boolean isEditable(Object node) {
        return false;
    }

    public String toString(Object value) {
        return value.toString();
    }

    public ActionListener getExecuteAction(TreePath[] paths) {
        return null;
    }

    public JPopupMenu getPopupMenu(TreePath[] paths) {
        return null;
    }

    public ActionListener getSelectionAction(TreeSelectionEvent event) {
        return null;
    }

    public String getTooltip(Object value) {
        return null;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListener = TreeModelEventMulticaster.addListener(this.treeModelListener, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListener = TreeModelEventMulticaster.removeListener(this.treeModelListener, treeModelListener);
    }

    public void refresh() {
        if (this.getRoot() != null) {
            this.fireTreeStructureChanged(new TreePath(this.getRoot()));
        }
    }

    public void nodesInserted(TreePath treePath, int[] childIndices, Object[] children) {
        if (treePath != null && childIndices != null && children != null && childIndices.length == children.length) {
            this.fireTreeNodesInserted(treePath, childIndices, children);
        }
    }

    public void nodeInserted(TreePath treePath, int childIndex, Object child) {
        this.nodesInserted(treePath, new int[]{childIndex}, new Object[]{child});
    }

    public void nodesRemoved(TreePath treePath, int[] childIndices, Object[] children) {
        if (treePath != null && childIndices != null && children != null && childIndices.length == children.length) {
            this.fireTreeNodesRemoved(treePath, childIndices, children);
        }
    }

    public void nodeRemoved(TreePath treePath, int childIndex, Object child) {
        this.nodesRemoved(treePath, new int[]{childIndex}, new Object[]{child});
    }

    public void nodesChanged(TreePath treePath, int[] childIndices, Object[] children) {
        if (treePath != null) {
            if (childIndices != null && children != null && childIndices.length == children.length) {
                this.fireTreeNodesChanged(treePath, childIndices, children);
            } else if (treePath.getPathCount() == 1) {
                this.fireTreeNodesChanged(treePath, null, null);
            }
        }
    }

    public void nodeChanged(TreePath treePath, int childIndex, Object child) {
        this.nodesChanged(treePath, new int[]{childIndex}, new Object[]{child});
    }

    public void nodeStructureChanged(TreePath treePath) {
        if (treePath != null) {
            this.fireTreeStructureChanged(treePath);
        }
    }

    protected void fireTreeNodesChanged(TreePath treePath, int[] childIndices, Object[] childs) {
        if (this.treeModelListener != null) {
            this.treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, treePath, childIndices, childs));
        }
    }

    protected void fireTreeNodesInserted(TreePath treePath, int[] childIndices, Object[] childs) {
        if (this.treeModelListener != null) {
            this.treeModelListener.treeNodesInserted(new TreeModelEvent((Object)this, treePath, childIndices, childs));
        }
    }

    protected void fireTreeNodesRemoved(TreePath treePath, int[] childIndices, Object[] childs) {
        if (this.treeModelListener != null) {
            this.treeModelListener.treeNodesRemoved(new TreeModelEvent((Object)this, treePath, childIndices, childs));
        }
    }

    protected void fireTreeStructureChanged(TreePath treePath) {
        if (this.treeModelListener != null) {
            this.treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, treePath));
        }
    }

    public Font getFont(Object value, Font originalFont) {
        return originalFont;
    }

    public Iterator<Object> children(Object root) {
        return new ChildIterator(root);
    }

    public Iterator<Object> breadthFirstIterator(Object root) {
        return new BreadthFirstIterator(root);
    }

    public Iterator<Object> depthFirstIterator(Object root) {
        return new PostorderIterator(root);
    }

    public Iterator<Object> preorderIterator(Object root) {
        return new PreorderIterator(root);
    }

    public Iterator<Object> postorderIterator(Object root) {
        return new PostorderIterator(root);
    }

    private static class EmptyIterator
    implements Iterator<Object> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
        }
    }

    final class ChildIterator
    implements Iterator<Object> {
        private Object root;
        private int childCount;
        private int index;

        public ChildIterator(Object root) {
            this.root = root;
            this.childCount = AbstractTreeModel.this.getChildCount(root);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.childCount;
        }

        @Override
        public Object next() {
            return AbstractTreeModel.this.getChild(this.root, this.index++);
        }

        @Override
        public void remove() {
        }
    }

    final class PostorderIterator
    implements Iterator<Object> {
        protected Object root;
        protected Iterator<Object> children;
        protected Iterator<Object> subtree;

        public PostorderIterator(Object root) {
            this.root = root;
            this.children = AbstractTreeModel.this.children(root);
            this.subtree = new EmptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public Object next() {
            Object retval;
            if (this.subtree.hasNext()) {
                retval = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                retval = this.subtree.next();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    final class PreorderIterator
    implements Iterator<Object> {
        protected Stack<Iterator<Object>> stack;

        public PreorderIterator(Object root) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(root);
            this.stack = new Stack();
            this.stack.push(list.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public Object next() {
            Iterator<Object> iterator = this.stack.peek();
            Object node = iterator.next();
            Iterator<Object> children = AbstractTreeModel.this.children(node);
            if (!iterator.hasNext()) {
                this.stack.pop();
            }
            if (children.hasNext()) {
                this.stack.push(children);
            }
            return node;
        }

        @Override
        public void remove() {
        }
    }

    final class BreadthFirstIterator
    implements Iterator<Object> {
        protected LinkedList<Iterator<Object>> queue;

        public BreadthFirstIterator(Object root) {
            ArrayList<Object> v = new ArrayList<Object>(1);
            v.add(root);
            this.queue = new LinkedList();
            this.queue.add(v.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty() && this.queue.element().hasNext();
        }

        @Override
        public Object next() {
            Iterator<Object> iterator = this.queue.element();
            Object node = iterator.next();
            Iterator<Object> children = AbstractTreeModel.this.children(node);
            if (!iterator.hasNext()) {
                this.queue.remove();
            }
            if (children.hasNext()) {
                this.queue.add(children);
            }
            return node;
        }

        @Override
        public void remove() {
        }
    }
}

