/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.document.FileTextFieldDocument;
import ch.e2e.swing.filechooser.FileChooserIcons;
import ch.e2e.util.StringTools;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class NewDirectoryDialog
extends ModalDialog {
    private JTextField directoryNameField;
    private JLabel newDirectoryLabel;

    public NewDirectoryDialog(JDialog owner) {
        super((Dialog)owner, translator.getTranslation("new.directory.title"), " ", translator.getTranslation("new.directory.subtitle"), (Icon)FileChooserIcons.folderNewBigIcon, 3);
        this.initialize();
    }

    public NewDirectoryDialog(JFrame owner) {
        super((Frame)owner, translator.getTranslation("new.directory.title"), "", translator.getTranslation("new.directory.subtitle"), (Icon)FileChooserIcons.folderNewBigIcon, 3);
        this.initialize();
    }

    public File getNewDirectory(File parent) {
        String title = translator.getTranslation("new.directory.title");
        this.setTitle(title);
        String subtitle = translator.getTranslation("new.directory.subtitle");
        this.setSubtitle(subtitle);
        String internalTitle = translator.getTranslation("new.directory.internaltitle");
        this.setInternalTitle(StringTools.replaceProperty((String)internalTitle, (String)"file", (String)parent.getAbsolutePath()));
        String label = translator.getTranslation("new.directory");
        this.newDirectoryLabel.setText(label);
        this.directoryNameField.setText("");
        int ret = this.showDialog();
        if (ret == 1) {
            return new File(parent, this.directoryNameField.getText());
        }
        return null;
    }

    private void initialize() {
        this.createGui();
        this.addEventHandler();
    }

    private void createGui() {
        this.setLayout(new GridLayout(2, 1, 0, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.newDirectoryLabel = new JLabel(translator.getTranslation("new.directory"));
        this.add(this.newDirectoryLabel);
        FileTextFieldDocument doc = new FileTextFieldDocument();
        doc.setMultipleSelection(false);
        this.directoryNameField = new JTextField(doc, "", 30);
        this.add(this.directoryNameField);
    }

    private void addEventHandler() {
    }

    static {
        translator.addMap("ch.e2e.swing.filechooser.filechooser");
    }
}

