/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.event.FileFilterChangedEvent;
import ch.e2e.swing.event.FileFilterListener;
import ch.e2e.swing.event.FileSelectedEvent;
import ch.e2e.swing.event.FileSelectedEventMulticaster;
import ch.e2e.swing.event.FileSelectedListener;
import ch.e2e.swing.filechooser.FilenameField;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.FileListModel;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.renderer.FileListCellRenderer;
import ch.e2e.swing.util.FileChooserFilter;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileList
extends JPanel
implements DirectorySelectedListener,
FileFilterListener,
ListSelectionListener,
FileSelectedListener,
FocusListener {
    private JList list;
    private Color selectionBackground;
    private FileListModel model;
    private ArrayList selectedFiles = new ArrayList();
    private FileSelectedListener fileListener;
    private DirectorySelectedListener directorySelectedListener;
    private ActionListener actionListener;
    private int[] selectedIndices = new int[0];
    private boolean fireDirectorySelected = true;
    private boolean fireFileSelected = true;
    private boolean hasFocus = false;
    private boolean doValueChanged = true;

    public FileList() {
        super(new BorderLayout());
        this.createGui();
        this.addEventHandler();
    }

    public FileListModel getModel() {
        return this.model;
    }

    public void setModelExtension(FileListModelExtension modelExtension) {
        this.model.setExtension(modelExtension);
        ListCellRenderer cellRenderer = this.list.getCellRenderer();
        if (cellRenderer instanceof FileListCellRenderer) {
            FileListCellRenderer renderer = (FileListCellRenderer)cellRenderer;
            renderer.setFileListModelExtension(modelExtension);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void addFileSelectedListener(FileSelectedListener listener) {
        this.fileListener = FileSelectedEventMulticaster.addListener(this.fileListener, listener);
        if (listener instanceof FilenameField) {
            final FilenameField filenameField = (FilenameField)listener;
            filenameField.addInputFieldListener(new InputFieldListener(){

                @Override
                public void inputFieldChanged(InputFieldEvent e) {
                    if (!FileList.this.hasFocus) {
                        FileList.this.fireFileSelected = false;
                        FileList.this.setSelectedFiles(filenameField.getFiles());
                        FileList.this.fireFileSelected = true;
                    }
                }
            });
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public void removeFileSelectedListener(FileSelectedListener listener) {
        this.fileListener = FileSelectedEventMulticaster.removeListener(this.fileListener, listener);
    }

    @Override
    public void fileFilterChanged(FileFilterChangedEvent event) {
        this.setSelectedFileFilter(event.getFileFilter());
    }

    public void setSelectedFileFilter(FileChooserFilter fileFilter) {
        this.model.setSelectedFileFilter(fileFilter);
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.addListener(this.directorySelectedListener, listener);
    }

    public void removeDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.removeListener(this.directorySelectedListener, listener);
    }

    @Override
    public void directorySelected(DirectorySelectedEvent event) {
        this.fireDirectorySelected = false;
        this.setSelectedDirectory(event.getDirectory());
        this.fireDirectorySelected = false;
    }

    public void setIncludeDirectories(boolean includeDirectories) {
        this.model.setIncludeDirectories(includeDirectories);
    }

    public void setSelectedDirectory(File file) {
        this.setSelectedDirectory(Directory.getDirectory(file));
    }

    private void setSelectedDirectory(Directory selectedDirectory) {
        File[] selectedFiles = new File[this.selectedIndices.length];
        for (int i = 0; i < this.selectedIndices.length; ++i) {
            Object value = this.model.getElementAt(this.selectedIndices[i]);
            if (value == null) continue;
            if (value instanceof File) {
                File file = (File)value;
                selectedFiles[i] = new File(selectedDirectory.getDir(), file.getName());
                continue;
            }
            Directory dir = (Directory)value;
            selectedFiles[i] = dir.isRoot() ? dir.getDir() : new File(selectedDirectory.getDir(), dir.getDir().getName());
        }
        this.model.setSelectedDirectory(selectedDirectory);
        this.selectedIndices = new int[0];
        this.setSelectedFiles(selectedFiles);
        if (this.fireDirectorySelected && this.directorySelectedListener != null) {
            this.fireDirectorySelected(selectedDirectory);
        }
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        this.fireFileSelected = false;
        this.setSelectedFiles(event.getFiles());
        this.fireFileSelected = true;
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public void setSelectedIndices(int[] selectedIndices) {
        this.selectedIndices = selectedIndices;
        this.list.setSelectedIndices(selectedIndices);
        this.selectedFiles.clear();
        for (int i = 0; i < selectedIndices.length; ++i) {
            this.selectedFiles.add(this.model.getElementAt(selectedIndices[i]));
        }
        this.scrollRectToVisible();
    }

    public void setSelectedFiles(File[] files) {
        this.doValueChanged = false;
        this.selectedIndices = this.model.getIndices(files);
        this.list.setSelectedIndices(this.selectedIndices);
        this.selectedFiles.clear();
        for (int i = 0; i < this.selectedIndices.length; ++i) {
            this.selectedFiles.add(files[i]);
        }
        this.doValueChanged = true;
        this.scrollRectToVisible();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.doValueChanged) {
            int[] newIndices = this.list.getSelectedIndices();
            if (newIndices != null && newIndices.length != 1 && this.selectedIndices != null) {
                this.checkNewIndices(newIndices);
            } else {
                this.selectedIndices = newIndices;
                this.fireFileSelected();
            }
        }
    }

    private void scrollRectToVisible() {
        if (this.selectedIndices != null && this.selectedIndices.length > 0 && this.selectedIndices[0] > this.list.getLastVisibleIndex()) {
            if (this.selectedIndices[0] == this.model.getSize() - 1) {
                Point p = this.list.indexToLocation(this.selectedIndices[0]);
                Dimension size = this.list.getSize();
                this.list.scrollRectToVisible(new Rectangle(p.x, p.y, 1, size.height - p.y));
            } else {
                Point p = this.list.indexToLocation(this.selectedIndices[0] + 1);
                this.list.scrollRectToVisible(new Rectangle(p.x, p.y - 1, 1, 0));
            }
        }
    }

    private void checkNewIndices(int[] newIndices) {
        int newIndex = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            boolean indexMissing = true;
            for (int j = 0; j < this.selectedIndices.length; ++j) {
                if (newIndices[i] != this.selectedIndices[j]) continue;
                indexMissing = false;
            }
            if (!indexMissing) continue;
            newIndex = newIndices[i];
            break;
        }
        if (newIndex != -1 && ((File)this.model.getElementAt(newIndex)).isDirectory()) {
            this.doValueChanged = false;
            this.list.setSelectedIndices(this.selectedIndices);
            this.doValueChanged = true;
        } else {
            this.selectedIndices = newIndices;
            this.fireFileSelected();
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public void reload() {
        this.model.reload();
    }

    private void createGui() {
        this.model = new FileListModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new FileListCellRenderer());
        this.list.setAutoscrolls(true);
        this.selectionBackground = this.list.getSelectionBackground().darker();
        JScrollPane sp = new JScrollPane(this.list, 20, 30);
        this.add((Component)sp, "Center");
    }

    private void addEventHandler() {
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                FileList.this.checkMouseSelection(event.getPoint());
                if (event.getClickCount() == 2) {
                    FileList.this.checkMouseAction(event);
                }
            }
        });
        this.list.addListSelectionListener(this);
        this.list.addFocusListener(this);
    }

    private void checkMouseSelection(Point mousePosition) {
        if (this.list.getSelectedIndices().length == 0) {
            int length = this.list.getModel().getSize();
            for (int i = 0; i < length; ++i) {
                if (!this.list.getCellBounds(i, i).contains(mousePosition)) continue;
                this.list.setSelectedIndex(i);
                break;
            }
        }
    }

    private void checkMouseAction(MouseEvent event) {
        if (this.selectedIndices != null) {
            int x = event.getX();
            int y = event.getY();
            if (this.selectedIndices.length == 1 && this.list.getSelectedValue() instanceof Directory && this.list.getCellBounds(this.selectedIndices[0], this.selectedIndices[0]).contains(x, y)) {
                this.doDirectoryAction();
            } else {
                for (int i = 0; i < this.selectedIndices.length; ++i) {
                    if (!this.list.getCellBounds(this.selectedIndices[i], this.selectedIndices[i]).contains(x, y)) continue;
                    this.doFileSelectionAction();
                    return;
                }
            }
        }
    }

    private void doDirectoryAction() {
        Directory selectedDirectory = (Directory)this.list.getSelectedValue();
        ActionListener action = this.model.getAction(selectedDirectory.getDir());
        if (action == null) {
            this.fireDirectorySelected(selectedDirectory);
            this.setSelectedDirectory(selectedDirectory);
        } else {
            action.actionPerformed(new ActionEvent(this, 1001, "fileListAction"));
        }
    }

    private void doFileSelectionAction() {
        ActionListener action;
        if (this.selectedIndices.length == 1) {
            File selectedFile = (File)this.list.getSelectedValue();
            action = this.model.getAction(selectedFile) == null ? this.actionListener : this.model.getAction(selectedFile);
        } else {
            ActionListener actionListener = action = this.model.getMultipleSelectionAction() == null ? this.actionListener : this.model.getMultipleSelectionAction();
        }
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 1001, "fileListAction"));
        }
    }

    private void fireDirectorySelected(Directory selectedDirectory) {
        if (this.directorySelectedListener != null) {
            this.directorySelectedListener.directorySelected(new DirectorySelectedEvent(this, selectedDirectory));
        }
    }

    private void fireFileSelected() {
        if (this.fileListener != null && this.selectedIndices != null && this.fireFileSelected) {
            ArrayList<Object> selectedFiles;
            this.doValueChanged = false;
            if (this.selectedIndices.length == 1 && this.model.getElementAt(this.selectedIndices[0]) instanceof Directory) {
                selectedFiles = new ArrayList();
            } else {
                selectedFiles = new ArrayList<Object>(this.selectedIndices.length);
                for (int i = 0; i < this.selectedIndices.length; ++i) {
                    selectedFiles.add(this.model.getElementAt(this.selectedIndices[i]));
                }
            }
            if (!this.selectedFiles.containsAll(selectedFiles) || !selectedFiles.containsAll(this.selectedFiles)) {
                this.selectedFiles = selectedFiles;
                File[] files = new File[selectedFiles.size()];
                selectedFiles.toArray(files);
                FileSelectedEvent event = new FileSelectedEvent(this, files);
                this.fileListener.fileSelected(event);
            }
            this.doValueChanged = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.list.setSelectionBackground(this.selectionBackground);
        int[] newIndices = this.list.getSelectedIndices();
        if (newIndices.length > 0) {
            this.selectedIndices = newIndices;
            this.fireFileSelected();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        Color selectionBackground = this.selectionBackground.brighter();
        this.list.setSelectionBackground(selectionBackground);
    }

    static class AllFilesFilter
    extends FileChooserFilter {
        AllFilesFilter() {
        }

        @Override
        public boolean acceptFile(File file) {
            return true;
        }

        @Override
        public String getDescription() {
            return "allfiles.filter";
        }
    }
}

