/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.Tree;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.DirectoryTreeModel;
import ch.e2e.swing.model.DirectoryTreeModelExtension;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DirectoryTree
extends JPanel
implements TreeSelectionListener,
TreeWillExpandListener,
DirectorySelectedListener {
    private Tree tree;
    private DirectoryTreeModel treeModel;
    private DirectorySelectedListener directorySelectedListener;
    private ActionListener actionListener;
    private boolean comeFromDirectorySelected = false;
    private DirectoryTreeModelExtension modelExtension;

    public DirectoryTree() {
        this((Directory)null);
    }

    public DirectoryTree(Directory directory) {
        super(new BorderLayout());
        this.createGui(directory);
        this.addEventHandler();
    }

    public void setModelExtension(DirectoryTreeModelExtension modelExtension) {
        this.modelExtension = modelExtension;
        this.treeModel.setExtension(modelExtension);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.treeModel.setExecuteAction(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        this.treeModel.setExecuteAction(actionListener);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Directory dir = (Directory)event.getPath().getLastPathComponent();
        dir.expand();
        if (this.modelExtension != null && !this.modelExtension.isExpandable(dir.getDir())) {
            throw new ExpandVetoException(event);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        if (event.getPath().getPathCount() == 1) {
            throw new ExpandVetoException(event);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (!this.comeFromDirectorySelected) {
            this.fireDirectorySelected((Directory)event.getPath().getLastPathComponent());
        }
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.addListener(this.directorySelectedListener, listener);
    }

    public void removeDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.removeListener(this.directorySelectedListener, listener);
    }

    @Override
    public void directorySelected(DirectorySelectedEvent event) {
        this.comeFromDirectorySelected = true;
        this.setSelectedDirectory(event.getDirectory());
        this.comeFromDirectorySelected = false;
    }

    public void scrollPathToVisible() {
        this.tree.scrollPathToVisible(this.tree.getSelectionPath());
    }

    public Directory getSelectedDirectory() {
        Directory selectedDir = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && path.getPathCount() > 1) {
            selectedDir = (Directory)path.getLastPathComponent();
        }
        return selectedDir;
    }

    public void refresh() {
        TreePath path = this.tree.getSelectionPath();
        this.tree.refresh();
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.setSelectedDirectory(Directory.getDirectory(selectedDirectory));
    }

    public void setSelectedDirectory(Directory selectedDirectory) {
        TreePath path = this.treeModel.setSelectedDirectory(selectedDirectory);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    public void setRoot(File root) {
        this.setRoot(Directory.getAsRoot(root));
    }

    public void setRoot(Directory root) {
        this.treeModel.setRoot(root);
    }

    private void fireDirectorySelected(Directory selectedDirectory) {
        if (this.directorySelectedListener != null) {
            this.directorySelectedListener.directorySelected(new DirectorySelectedEvent(this, selectedDirectory));
        }
    }

    private void addEventHandler() {
        this.tree.addTreeWillExpandListener(this);
        this.tree.addTreeSelectionListener(this);
    }

    private void createGui(Directory directory) {
        this.treeModel = new DirectoryTreeModel(directory);
        this.tree = new Tree(this.treeModel);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        this.add((Component)new JScrollPane(this.tree, 20, 30), "Center");
    }
}

