/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.event.DirectoryActionEvent;
import ch.e2e.swing.filechooser.FileDialog;
import ch.e2e.swing.model.Directory;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;

public class DirectoryChooser
extends FileDialog {
    private MouseOverButton showFilesButton;

    public DirectoryChooser(Frame owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle);
    }

    public DirectoryChooser(JDialog owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle);
    }

    public DirectoryChooser(Frame owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon);
    }

    public DirectoryChooser(JDialog owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon);
    }

    @Override
    public void createNewDirectory(DirectoryActionEvent event) {
        File newDirectory = this.createNewDirectory(event.getDirectory().getDir());
        if (newDirectory != null) {
            this.fileList.reload();
            this.fileList.setSelectedFiles(new File[]{newDirectory});
        }
    }

    public File selectDirectory(File startDir) {
        int ret;
        Directory startDirectory = Directory.getDirectory(this.getExistingStartDir(startDir));
        this.directoryComboBox.setSelectedDirectory(startDirectory.getParent());
        if (startDir.exists()) {
            this.fileList.setSelectedFiles(new File[]{startDir});
        }
        if ((ret = this.showDialog()) == 1) {
            return ((Directory)this.fileList.getSelectedValues()[0]).getDir();
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.fileList.getSelectedValues().length > 0 && this.fileList.getSelectedValues()[0] instanceof Directory) {
            Directory dir = (Directory)this.fileList.getSelectedValues()[0];
            this.setOkButtonEnabled(this.listModelExtension == null || this.listModelExtension.isSelectable(dir.getDir()));
        } else {
            this.setOkButtonEnabled(false);
        }
    }

    @Override
    protected GridBagConstraints createGui() {
        GridBagConstraints c = super.createGui();
        this.showFilesButton = this.addSmallButton((Icon)showFilesIcon, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DirectoryChooser.this.doShowFilesAction();
            }
        });
        this.showFilesButton.setPressed(false, true);
        this.setOkButtonEnabled(false);
        return c;
    }

    @Override
    protected String getDirectoryComboBoxLabel() {
        return "filechooser.directoryname";
    }

    private void doShowFilesAction() {
        boolean pressed = !this.showFilesButton.isPressed();
        this.showFilesButton.setPressed(pressed, true);
        if (pressed) {
            this.fileList.setSelectedFileFilter(this.allFilesFilter);
        } else {
            this.fileList.setSelectedFileFilter(null);
        }
    }

    @Override
    protected void addEventHandler() {
        super.addEventHandler();
        this.directoryTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DirectoryChooser.this.okDialog();
            }
        });
    }

    private File getExistingStartDir(File startDir) {
        startDir = startDir.getAbsoluteFile();
        while (!startDir.exists()) {
            if ((startDir = startDir.getParentFile()) != null) continue;
            startDir = new File("").getAbsoluteFile();
        }
        return startDir;
    }
}

