/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;

public abstract class GenericNumberFieldDocument<T extends Number>
extends PlainDocument {
    static final int DOUBLE_FIELD = 1;
    static final int INTEGER_FIELD = 2;
    private int type;
    private boolean decimalPointSet = false;
    private DecimalFormat decimalFormat;
    private T minimum;
    private T maximum;
    private int maxDigits = 0;
    private boolean beepOnError = true;

    protected GenericNumberFieldDocument(int type, T min, T max) {
        this.type = type;
        this.minimum = min;
        this.maximum = max;
        this.createDecimalFormat();
        this.evaluateMaxDigits();
    }

    protected abstract T newValue(String var1);

    public void setMaximum(T maximum) {
        this.maximum = maximum;
        this.evaluateMaxDigits();
    }

    public void setMinimum(T minimum) {
        this.minimum = minimum;
        this.evaluateMaxDigits();
    }

    @Override
    public void insertString(int offset, String insert, AttributeSet attributes) throws BadLocationException {
        if (this.minimum != null && this.maximum != null && this.getLength() + insert.length() > this.maxDigits) {
            this.failure();
            return;
        }
        if (!this.containsOnlyDigits(insert)) {
            this.failure();
            return;
        }
        String text = this.getText(0, this.getLength());
        String number = text.substring(0, offset);
        number = number + insert;
        number = number + text.substring(offset, text.length());
        if (this.isGroupingUsed() && !this.checkGrouping(number)) {
            this.failure();
            return;
        }
        if ((number = this.getCleanedText(number)).length() > 0 && !this.checkNumber(number)) {
            this.failure();
            return;
        }
        super.insertString(offset, insert, attributes);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        String text = this.getText(0, this.getLength());
        String number = text.substring(0, offset);
        if ((number = number + text.substring(offset + length, text.length())).indexOf(".") == -1) {
            this.decimalPointSet = false;
        }
        super.remove(offset, length);
        if (this.getText(0, this.getLength()).indexOf(this.getGroupingSeparator()) != -1) {
            this.format(this.getActualValue());
        }
    }

    public void format(T value) {
        try {
            this.remove(0, this.getLength());
            if (value != null) {
                super.insertString(0, this.decimalFormat.format(value), new StyleContext().getEmptySet());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public T getActualValue() {
        try {
            return this.newValue(this.getCleanedText(this.getText(0, this.getLength())));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setDecimalSeparator(char decimalSeparator) {
        T actualValue = this.getActualValue();
        DecimalFormatSymbols symbols = this.decimalFormat.getDecimalFormatSymbols();
        symbols = this.createDecimalFormatSymbols(decimalSeparator, symbols.getGroupingSeparator(), symbols.getNaN());
        this.decimalFormat.setDecimalFormatSymbols(symbols);
        this.format(actualValue);
    }

    public char getDecimalSeparator() {
        return this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setFractionDigits(int fractionDigits) {
        this.decimalFormat.setMinimumFractionDigits(fractionDigits);
        this.decimalFormat.setMaximumFractionDigits(fractionDigits);
        this.evaluateMaxDigits();
        this.format(this.getActualValue());
    }

    public int getFractionDigits() {
        return this.decimalFormat.getMinimumFractionDigits();
    }

    public void setMinimumFractionDigits(int fractionDigits) {
        this.decimalFormat.setMinimumFractionDigits(fractionDigits);
        this.evaluateMaxDigits();
        this.format(this.getActualValue());
    }

    public int getMinimumFractionDigits() {
        return this.decimalFormat.getMinimumFractionDigits();
    }

    public void setMaximumFractionDigits(int fractionDigits) {
        this.decimalFormat.setMaximumFractionDigits(fractionDigits);
        this.evaluateMaxDigits();
        this.format(this.getActualValue());
    }

    public int getMaximumFractionDigits() {
        return this.decimalFormat.getMaximumFractionDigits();
    }

    public void setGroupingSize(int groupingSize) {
        this.decimalFormat.setGroupingSize(groupingSize);
        this.evaluateMaxDigits();
        this.format(this.getActualValue());
    }

    public int getGroupingSize() {
        return this.decimalFormat.getGroupingSize();
    }

    public void setGroupingSeparator(char groupingSeparator) {
        T actualValue = this.getActualValue();
        DecimalFormatSymbols symbols = this.decimalFormat.getDecimalFormatSymbols();
        symbols = this.createDecimalFormatSymbols(symbols.getDecimalSeparator(), groupingSeparator, symbols.getNaN());
        this.decimalFormat.setDecimalFormatSymbols(symbols);
        this.format(actualValue);
    }

    public char getGroupingSeparator() {
        return this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this.decimalFormat.setGroupingUsed(groupingUsed);
        this.evaluateMaxDigits();
        this.format(this.getActualValue());
    }

    public boolean isGroupingUsed() {
        return this.decimalFormat.isGroupingUsed();
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public void setBeepOnError(boolean beepOnError) {
        this.beepOnError = beepOnError;
    }

    protected void createDecimalFormat() {
        this.decimalFormat = new DecimalFormat();
        DecimalFormatSymbols symbols = this.createDecimalFormatSymbols('.', '\'', "");
        this.decimalFormat.setDecimalFormatSymbols(symbols);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
        this.decimalFormat.setGroupingSize(3);
        this.decimalFormat.setMinimumIntegerDigits(1);
    }

    private void evaluateMaxDigits() {
        int min = this.decimalFormat.format(this.minimum == null ? Long.valueOf(Long.MIN_VALUE) : this.minimum).length();
        int max = this.decimalFormat.format(this.maximum == null ? Long.valueOf(Long.MAX_VALUE) : this.maximum).length();
        this.maxDigits = Math.max(min, max);
    }

    private String getCleanedText(String text) {
        if (text.length() > 0 && text.indexOf(this.getGroupingSeparator()) != -1) {
            text = this.removeChar(text, this.getGroupingSeparator());
        }
        return text;
    }

    private String removeChar(String str, char charToRemove) {
        StringBuffer dummy = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == charToRemove) continue;
            dummy.append(str.charAt(i));
        }
        return new String(dummy);
    }

    private boolean containsOnlyDigits(String insert) {
        boolean containsOnlyDigits = true;
        int length = insert.length();
        for (int i = 0; containsOnlyDigits && i < length; ++i) {
            char testChar = insert.charAt(i);
            if (Character.isDigit(testChar)) continue;
            if (testChar == this.getGroupingSeparator()) {
                if (this.isGroupingUsed()) continue;
                containsOnlyDigits = this.failure();
                continue;
            }
            if (this.type == 1) {
                if (testChar != this.getDecimalSeparator() || this.decimalPointSet) continue;
                this.decimalPointSet = true;
                continue;
            }
            if (testChar == '-' && (this.minimum == null || !(((Number)this.minimum).doubleValue() >= 0.0))) continue;
            containsOnlyDigits = this.failure();
        }
        return containsOnlyDigits;
    }

    private boolean checkNumber(String text) {
        return text.equals("-") || this.maximum == null || ((Comparable)this.newValue(text)).compareTo(this.maximum) <= 0 || this.failure();
    }

    private boolean failure() {
        if (this.beepOnError) {
            Toolkit.getDefaultToolkit().beep();
        }
        return false;
    }

    private DecimalFormatSymbols createDecimalFormatSymbols(char decimalSeparator, char groupingSeparator, String nan) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(decimalSeparator);
        symbols.setGroupingSeparator(groupingSeparator);
        symbols.setNaN(nan);
        return symbols;
    }

    private boolean checkGrouping(String text) {
        int index = text.indexOf(this.getGroupingSeparator());
        if (index == -1) {
            return true;
        }
        if (index == 0 || index > this.getGroupingSize()) {
            return false;
        }
        do {
            text = text.substring(index + 1, text.length());
            System.out.println("text = " + text);
            index = text.indexOf(this.getGroupingSeparator());
            if (index != -1) continue;
            return true;
        } while (index == this.getGroupingSize());
        return false;
    }
}

