/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.StatusBarActionSection;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class StatusBarMovingSection
extends StatusBarActionSection {
    private String[] texts = null;
    private int text = 0;
    private Icon[] icons = null;
    private Icon emptyIcon;
    private int icon = 0;

    public StatusBarMovingSection(String[] texts, int delay) {
        super(delay);
        this.texts = texts;
    }

    public StatusBarMovingSection(Icon[] icons, int delay) {
        super(delay);
        this.icons = icons;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.icons != null && this.icons.length > 0) {
            this.emptyIcon = new ImageIcon(this.createImage(this.icons[0].getIconWidth(), this.icons[0].getIconHeight()));
            this.setIcon(this.emptyIcon);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setNextIcon();
        this.setNextText();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.emptyIcon != null) {
            this.setIcon(this.emptyIcon);
        }
        this.icon = 0;
        this.text = 0;
    }

    private void setNextIcon() {
        if (this.icons != null) {
            this.setIcon(this.icons[this.icon]);
            ++this.icon;
            if (this.icon == this.icons.length) {
                this.icon = 0;
            }
        }
    }

    private void setNextText() {
        if (this.texts != null) {
            this.setText(this.texts[this.text]);
            ++this.text;
            if (this.text > this.texts.length) {
                this.text = 0;
            }
        }
    }
}

