/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.SplitPaneUI;
import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class SplitPane
extends JSplitPane {
    private SplitPaneUI ui;
    private int realDividerSize = 5;
    private Double proportionalLocation;

    public SplitPane() {
        this(1, false, null, null);
    }

    public SplitPane(int newOrientation) {
        this(newOrientation, false);
    }

    public SplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public SplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public SplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
    }

    public void setRealDividerSize(int realDividerSize) {
        this.realDividerSize = realDividerSize;
        super.setDividerSize(realDividerSize);
    }

    @Override
    public void setDividerSize(int newSize) {
        super.setDividerSize(this.realDividerSize);
    }

    @Override
    public void setDividerLocation(double proportionalLocation) {
        if (this.getOrientation() == 0 && this.getHeight() == 0 || this.getOrientation() == 1 && this.getWidth() == 0) {
            this.proportionalLocation = proportionalLocation;
        } else {
            this.proportionalLocation = null;
            super.setDividerLocation(proportionalLocation);
        }
    }

    @Override
    public void setDividerLocation(int location) {
        this.proportionalLocation = null;
        super.setDividerLocation(location);
    }

    @Override
    public int getDividerLocation() {
        if (this.proportionalLocation != null && (this.getOrientation() == 0 && this.getHeight() != 0 || this.getOrientation() == 1 && this.getWidth() != 0)) {
            super.setDividerLocation(this.proportionalLocation);
        }
        return super.getDividerLocation();
    }

    @Override
    public javax.swing.plaf.SplitPaneUI getUI() {
        if (this.ui == null) {
            this.ui = (SplitPaneUI)SplitPaneUI.createUI(this);
        }
        return this.ui;
    }

    @Override
    public void setBottomComponent(Component comp) {
        this.setRightComponent(comp);
    }

    @Override
    public void setTopComponent(Component comp) {
        this.setLeftComponent(comp);
    }

    @Override
    public void setLeftComponent(Component comp) {
        super.setLeftComponent(comp);
        this.setDividerVisible();
    }

    @Override
    public void setRightComponent(Component comp) {
        super.setRightComponent(comp);
        this.setDividerVisible();
    }

    public void setUI(SplitPaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(this.getUI());
        this.revalidate();
    }

    private void setDividerVisible() {
        BasicSplitPaneDivider divider = this.ui.getDivider();
        if (divider != null) {
            divider.setVisible(this.leftComponent != null && this.rightComponent != null);
        }
    }
}

