/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputTextArea
extends JTextArea
implements InputField,
DocumentListener {
    private InputFieldListener listener;
    private Color background;
    private Color disabledBackground = Color.lightGray;
    private Font realFont;

    public InputTextArea() {
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    public InputTextArea(int rows, int columns) {
        super(rows, columns);
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    public InputTextArea(String text) {
        super(text);
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    @Override
    public Object getContent() {
        return this.getText();
    }

    @Override
    public void setContent(Object content) {
        this.setText(content.toString());
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            InputFieldEvent e = new InputFieldEvent(this);
            this.listener.inputFieldChanged(e);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
        super.setBackground(background);
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        super.setEditable(enabled);
        super.setBackground(enabled ? this.background : this.disabledBackground);
    }

    public void setRealFont(Font realFont) {
        this.realFont = realFont;
    }

    @Override
    public void setFont(Font f) {
        if (this.realFont != null) {
            super.setFont(this.realFont);
        } else {
            super.setFont(f);
        }
    }
}

