/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.GenericInputNumberField;
import ch.e2e.swing.document.BigIntegerFieldDocument;
import java.math.BigInteger;

public class InputBigIntegerField
extends GenericInputNumberField<BigInteger> {
    public InputBigIntegerField(BigInteger min, BigInteger max, BigInteger increment, BigInteger startValue) {
        super(new BigIntegerFieldDocument(min, max), min, max, increment);
        this.setContent(startValue);
    }

    public InputBigIntegerField(BigInteger min, BigInteger max, BigInteger increment) {
        this(min, max, increment, null);
    }

    public InputBigIntegerField(BigInteger min, BigInteger max) {
        this(min, max, BigInteger.ZERO);
    }

    public InputBigIntegerField() {
        this(null, null, BigInteger.ZERO);
    }

    public InputBigIntegerField(String min, String max, String increment, String startValue) {
        this(new BigInteger(min), new BigInteger(max), new BigInteger(increment), new BigInteger(startValue));
    }

    public InputBigIntegerField(String min, String max, String increment) {
        this(new BigInteger(min), new BigInteger(max), new BigInteger(increment));
    }

    public InputBigIntegerField(String min, String max) {
        this(new BigInteger(min), new BigInteger(max));
    }

    public InputBigIntegerField(long min, long max, long increment, long startValue) {
        this(BigInteger.valueOf(min), BigInteger.valueOf(max), BigInteger.valueOf(increment), BigInteger.valueOf(startValue));
    }

    public InputBigIntegerField(long min, long max, long increment) {
        this(BigInteger.valueOf(min), BigInteger.valueOf(max), BigInteger.valueOf(increment));
    }

    public InputBigIntegerField(long min, long max) {
        this(BigInteger.valueOf(min), BigInteger.valueOf(max));
    }

    @Override
    protected boolean isNaN(BigInteger value) {
        return value == null;
    }

    @Override
    protected BigInteger newValue(BigInteger value) {
        return new BigInteger(value.toString());
    }

    @Override
    protected BigInteger increment(BigInteger value) {
        return value.add((BigInteger)this.increment);
    }

    @Override
    protected BigInteger decrement(BigInteger value) {
        return value.subtract((BigInteger)this.increment);
    }
}

