/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.model;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Node;

public class XmiIdCopier {
    public static void copy(Collection<Object[]> elements, String[] args) throws Exception {
        ArrayList<FileContent> targetFiles = new ArrayList<FileContent>();
        for (int i = 1; i < args.length; ++i) {
            targetFiles.add(new FileContent(new File(args[i])));
        }
        for (Object[] element : elements) {
            String xmiId2;
            Node[] nodes = (Node[])element[1];
            if (nodes[0] == null || nodes[1] == null) continue;
            Node xmiIdNode1 = nodes[0].getAttributes() != null ? nodes[0].getAttributes().getNamedItem("xmi:id") : null;
            Node xmiIdNode2 = nodes[1].getAttributes() != null ? nodes[1].getAttributes().getNamedItem("xmi:id") : null;
            String xmiId1 = xmiIdNode1 != null ? xmiIdNode1.getTextContent() : "";
            String string = xmiId2 = xmiIdNode2 != null ? xmiIdNode2.getTextContent() : "";
            if (xmiId1.isEmpty() || xmiId2.isEmpty()) continue;
            for (FileContent fileContent : targetFiles) {
                fileContent.content = fileContent.content.replaceAll(xmiId2, xmiId1);
            }
        }
        for (FileContent fileContent : targetFiles) {
            fileContent.save();
        }
    }

    static class FileContent {
        public File file;
        public String content;

        FileContent(File file) throws IOException {
            this.file = file;
            this.content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }

        void save() throws IOException {
            Files.write(this.file.toPath(), this.content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }
}

