/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.models;

import ch.e2e.builder.compiler.models.E2EBridgeModelGenerator;
import ch.e2e.dom.DomUtilities;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.util.ArgumentParser;
import java.io.File;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E2EBridgeCustomizationParser {
    private static Transformer propertyGroupTransformer;
    static Document modelDoc;

    public static void main(String[] args) throws Exception {
        ArgumentParser argsParser = new ArgumentParser(args);
        modelDoc = DomUtilities.parse((File)new File("build/resources/main/ch/e2e/builder/compiler/models/models-final.xml"));
        TransformerLoader transformerLoader = new TransformerLoader(new File("src/main/xslt"), E2EBridgeModelGenerator.class.getClassLoader());
        Templates transformPropertyGroupTemplates = transformerLoader.getTemplates(new File("templates/MD 18.0/transformPropertyGroup.xsl"));
        propertyGroupTransformer = transformPropertyGroupTemplates.newTransformer();
        Templates customizationParseTemplate = transformerLoader.getTemplates(new File("templates/MD 18.0/parse_customizations.xsl"));
        Transformer customizationParseTransformer = customizationParseTemplate.newTransformer();
        File sourceFile = new File("templates/MD 18.0/E2E Bridge Base edit.xml");
        File customizationFile = new File("templates/MD 18.0/E2E Bridge Customization parsed edit.xml");
        DOMResult result = new DOMResult();
        customizationParseTransformer.transform(new StreamSource(sourceFile), result);
        DomUtilities.serialize((File)customizationFile, (Node)result.getNode(), (boolean)true);
        Document customizations = DomUtilities.parse((File)customizationFile, (boolean)false, (boolean)false, (boolean)false);
        File rootProfileFolder = new File("src/main/resources/ch/e2e/builder/compiler/models/profile");
        E2EBridgeCustomizationParser.profileFolder(rootProfileFolder, customizations);
    }

    private static void profileFolder(File folder, Document customizations) throws Exception {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                E2EBridgeCustomizationParser.profileFolder(file, customizations);
                continue;
            }
            if (!file.getName().endsWith("stereotype.xml")) continue;
            E2EBridgeCustomizationParser.stereotypeFile(file, customizations);
        }
    }

    private static void stereotypeFile(File file, Document customizations) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Document stereotypeDoc = DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)false);
        Element stereotype = stereotypeDoc.getDocumentElement();
        String stereotypeId = stereotype.getAttribute("xmi:id");
        Node customizationNode = ((NodeList)xPath.compile("//*[local-name()='class' and @*[local-name() = 'id'] = 'E2E Bridge Profile.xml#" + stereotypeId + "']/*[local-name()='customization']").evaluate(customizations, XPathConstants.NODESET)).item(0);
        if (customizationNode != null) {
            Node importElement = stereotype.getOwnerDocument().importNode(customizationNode, true);
            stereotype.appendChild(importElement);
        }
        DomUtilities.serialize((File)file, (Document)stereotypeDoc, (boolean)true);
        DOMResult result = new DOMResult();
        propertyGroupTransformer.transform(new StreamSource(file), result);
        DomUtilities.serialize((File)file, (Node)result.getNode(), (boolean)true);
        stereotypeDoc = DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)false);
        NodeList refNodes = (NodeList)xPath.compile("//@type | //@href | //@idref | //@*[parent::ebm:appliedStereotype]").evaluate(stereotypeDoc, XPathConstants.NODESET);
        for (int i = refNodes.getLength() - 1; i >= 0; --i) {
            Node node = refNodes.item(i);
            String value = node.getNodeValue();
            if (!value.startsWith("E2E Bridge Profile.xml.zip#")) continue;
            String xmiId = value.substring(value.lastIndexOf("#") + 1);
            Node ebmId = ((NodeList)xPath.compile("//*[@*[local-name() = 'id' and namespace-uri() = 'http://schema.omg.org/spec/XMI'] = '" + xmiId + "']/@*[local-name() = 'id' and namespace-uri() = 'http://e2e.ch/bridge/models']").evaluate(modelDoc, XPathConstants.NODESET)).item(0);
            if (ebmId == null) continue;
            node.setNodeValue("ebm:" + ebmId.getNodeValue());
        }
        DomUtilities.serialize((File)file, (Document)stereotypeDoc, (boolean)true);
    }
}

