/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree.menu;

import ch.e2e.builder.analyzer.gui.tree.menu.Logging;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogsRoot;
import ch.e2e.builder.analyzer.model.event.TransactionLogEvent;
import ch.e2e.builder.analyzer.tree.RefreshTransactionLogsTreeEvent;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.util.StringTools;
import java.util.EventObject;

public class DeleteTransactionLogExecuter
implements EventExecuter,
Logging {
    private static final String TRANSACTION_LOG = "transactionLog";
    private static final String DELETE_QUESTION_MESSAGE = "transactionLog.delete.question.message";
    private static final String DELETE_QUESTION_SUBTITLE = "transactionLog.delete.question.subtitle";
    private static final String DELETE_QUESTION_TITLE = "transactionLog.delete.question.title";
    private E2ETraceModule module;

    public DeleteTransactionLogExecuter(E2ETraceModule module) {
        this.module = module;
    }

    public void execute(EventObject event) {
        TransactionLog transactionLog = (TransactionLog)((TransactionLogEvent)event).getTransactionObject();
        String name = transactionLog.toString();
        String question = this.module.getTranslation(DELETE_QUESTION_MESSAGE);
        question = StringTools.replaceProperty((String)question, (String)TRANSACTION_LOG, (String)name);
        String title = this.module.getTranslation(DELETE_QUESTION_TITLE);
        title = StringTools.replaceProperty((String)title, (String)TRANSACTION_LOG, (String)name);
        String subtitle = this.module.getTranslation(DELETE_QUESTION_SUBTITLE);
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)TRANSACTION_LOG, (String)name)), (String)question)) {
            TransactionLogsRoot parent = (TransactionLogsRoot)transactionLog.getParent();
            parent.delete(transactionLog);
            EventController.fire((EventObject)new RefreshTransactionLogsTreeEvent(this, (TransactionLogObject)parent));
        }
    }
}

